<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Banque;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\BanqueRequest;
use View;
 
class BanquesController extends Controller {

    private $menu_home='versements';
    private $menu='versements';
    private $submenu='banques';

    public function index()
    {
       if(!($user=Auth::user())) return Redirect::route( 'login' );
       if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BQE_VISU")) return redirect('home');

       $banques = Banque::all();

        return View::make('tiers.banques.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'banques'=>$banques
        ]);
    }
 
    public function create($mode="create")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BQE_AJO")) return redirect('home');
        return $this->create_generic("create");
    }


    public function create_generic($mode="create",$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $banque = [];
        if($id) $banque = Banque::find($id);

        return View::make('tiers.banques.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
            "banque" => $banque,
        ]);
    }


    public function store(BanqueRequest $request)
    {
        $banque = $this->setData($request);
        $msg="La Banque ".$banque->nom." a été créée";
        Session::flash('message', $msg);
        return Redirect::to('banques');
    }
 

    public function edit($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BQE_MAJ")) return redirect('home');

        return $this->create_generic("edit",$id);
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BQE_VISU")) return redirect('home');

        return $this->create_generic("show",$id);
    }

    public function update($id,BanqueRequest $request)
    {
        $banque = $this->setData($request,$id);
        $msg="La Banque ".$banque->nom." a été mis à jour";
        Session::flash('message', $msg);
        return Redirect::to('banques');
    }
 

    public function destroy($id)
    {
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BQE_SUP")) return redirect('home');

        Banque::destroy($id);
        return Redirect::to('banques');
    }
 
    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $banque =  new Banque;
        else $banque = Banque::find($id);
        
        $banque->nom  = $request->nom;
        $banque->adresse  = $request->adresse;
        $banque->cp  = $request->cp;
        $banque->ville  = $request->ville;
        $banque->tel  = $request->tel;
        $banque->email  = $request->email;
        $banque->contact  = $request->contact;
        $banque->agence  = $request->agence;
        $banque->bic  = $request->bic;
        $banque->save();

        return $banque;
    }



}