<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\Sipre\SipreBeneficiaire;
use App\Models\Sipre\SipreParametre;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
 

/* ****************************** */
/* AAE
/* ****************************** */
class CPSWFController extends Controller {
    private $menu_home="base";
    private $menu='dossiers';
    private $submenu='cpswf_benef';
    
    //Liste générique
    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("CPSWF_CONSULT")) return redirect('home');

        $title="Bénéficiares CPSWF";
        
        //$beneficiaires=SipreBeneficiaire::where('id','=','16460')->get();
        $SIPRE_parametres=SipreParametre::where('ref', '=', 'PARTAGE_SITAS')->first();
        $tp=explode(";",$SIPRE_parametres->value);
        $t_param=[];$beneficiaires=[];
        foreach($tp as $p) $t_param[$p]=$p;
        if(isset($t_param['active'])) {
            $statut="";
            if(isset($t_param['benef_allocations'])) $statut.="A;AN;AR;AAU;AAV;SAV;RVE;SAA;AS";
            if(isset($t_param['benef_retraites'])) $statut.="R;RA;RAU;RAV;RVE;AR;SAR;AAV;O";
            $t_statuts=explode(";",$statut);
            $date_max=date('Y-m', strtotime('-3 month')); //3 mois
            $beneficiaires_obj=SipreBeneficiaire::whereIn("statut",$t_statuts);
            $beneficiaires_obj=$beneficiaires_obj->whereIn('id', function($query) use ($date_max){
                $query->select('versem.benum')
                ->from('versem')
                ->where('date','like',$date_max.'%');
            });
            $beneficiaires=$beneficiaires_obj->get();
        }
        return View::make('cpswf.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'t_param' => $t_param,
            'beneficiaires' => $beneficiaires,
        ]);
    }
    
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("CPSWF_VISU")) return redirect('home');

        $beneficiaire_cpswf=SipreBeneficiaire::find($id);
        return View::make('cpswf.show', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            "beneficiaire_cpswf" => $beneficiaire_cpswf,
        ]);
    }
 

}