<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\MyApp;
use App\Models\Log;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\Famille;
use App\Models\FamilleEnfant;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Redirect;
use View;


class CertificatsController extends Controller {
    private $menu_home="aides";
    private $menu='aae';
    private $submenu='maj_certificats';

    public function index_certificats($etrangers=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($etrangers) {$this->submenu="maj_certificats_etrangers";}

        $titre_versement="Remise à zéro des Certificats NC,Uvea,Futuna pour les enfants";
        if($etrangers) $titre_versement="Remise à zéro des Certificats Hors NC,Uvea,Futuna pour les enfants";

        $enfants=$this->getEnfants($etrangers);
        $nb_enfants=$enfants->count();
        $nb_change=0;
        foreach($enfants as $enfant) {
            if($enfant->certificat_enfant!=$enfant->NewCertificat)
                $nb_change++;
        }
        $nb_enfants=($nb_change+$nb_enfants==0)?"0":$nb_change."/".$nb_enfants;

        return View::make('certificats.maj_certificats', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'titre_versement' => $titre_versement,
            'etrangers' => $etrangers,'nb_enfants' => $nb_enfants,
        ]);
    }


    public function index_certificats_etrangers($type,$nb_modif="")
    {
        return $this->index_certificats(true);
    }


    public function info_certificats($etrangers=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($etrangers) {$this->submenu="maj_certificats_exterieur";}

        $titre_versement="Remise à zéro des Certificats NC,Uvea,Futuna pour les Enfants";
        if($etrangers) $titre_versement="Remise à zéro des Certificats Hors NC,Uvea,Futuna pour les Enfants";

        //Recherche existants
        $enfants=$this->getEnfants($etrangers);
        
        //Mode <>"" si message de fin d'opération
        return View::make('certificats.info_certificats', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'titre_versement' => $titre_versement,
            'enfants' => $enfants,
            'etrangers' => $etrangers,
        ]);
    }


    public function maj_certificats_etrangers()
    {
        return $this->maj_certificats(true);
    }

    public function maj_certificats($etrangers=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($etrangers) $this->submenu="maj_certificats_etrangers";
        else $this->submenu="maj_certificats";

        //Recherche existants
        $enfants=$this->getEnfants($etrangers);
        //Mise à jour
        $nb_modif=0;
        foreach($enfants as $enfant) {
            $enfant->certificat_enfant =$enfant->NewCertificat;
            $enfant->save();
            $nb_modif++;
        }

        return View::make('certificats.maj_certificats_fin', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'nb_modif' => $nb_modif,
            'etrangers' => $etrangers,
        ]);
    }


    public function getEnfants($etrangers)
    {
        //Recherche existants
        $age_mini_enfant=MyApp::getParam('AAE_AGE_MIN_RAZ_CERTIF');
        $allocataires=Allocataire::where('types_aides','like','%AAE%')->get(); //Allocataires avec Aide à l'enfant
        $enfants=new Collection();
        foreach($allocataires as $allocataire) {
            $famille=Famille::find($allocataire->id_famille);
            if($famille && $famille->id_titulaire==$allocataire->id) {
                $famillesenfants = FamilleEnfant::where('id_famille','=',$famille->id)->get();
                foreach($famillesenfants as $familleenfant) {
                    $enfant=Allocataire::find($familleenfant->id_enfant);
                    $eligible=false;
                    if($enfant->Age<22 || $enfant->certificat_enfant) {
                        if($etrangers && $enfant->certificat_enfant==4) $eligible=true; //Si Métropole && Polynésie
                        if(!$etrangers && $enfant->certificat_enfant!=4 && $enfant->age>=$age_mini_enfant) $eligible=true; //Si NC,Wallis & Futuna   
                        if($eligible) $enfants->push($enfant);
                    } 
                }
            }
        }
        $enfants=$enfants->sortBy([['nom', 'asc'],['prenom', 'asc']]);
        return $enfants;
    }
}
