<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Document;
use App\Models\MyApp;
use App\Models\Allocataire;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\DocumentRequest;

use View;
use DB;

class DocumentsController extends Controller {

    private $menu_home='base';
    private $menu='dossiers';
    private $submenu='documents';

    public function index()
    {
       if(!($user=Auth::user())) return Redirect::route( 'login' );
       if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DOC_VISU")) return redirect('home');
        $documents = AllocataireRessource::all();

        return View::make('documents.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'documents'=>$documents
        ]);
    }
 
    public function create($allocataire_id="",$mode_frame=false) {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DOC_AJO")) return redirect('home');
        $mode="create";
        $types_documents=MyApp::getZBase("DOC_TYPES");

        return View::make('documents.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode"=>$mode,
            "types_documents" => $types_documents,"mode_frame" => $mode_frame,
            "allocataire_id"=>$allocataire_id
        ]);
    }

    
    public function create_pop($allocataire_id,$mode="create") {
        
        return $this->create($allocataire_id,true);
    }

    public function store(DocumentRequest $request)
    {
        $id_allocataire=$request->id_allocataire;
        $allocataire=Allocataire::find($id_allocataire);
        
        if($request->file('doc_file')&&$allocataire) {
            $file=$request->file('doc_file');
            $size=$file->getSize();
            if($size < 2096576) { //2 MB (size is also in bytes)
                $extension = $file->extension();
                $name = $file->getClientOriginalName();;
                //$nom_file='doc_'.$allocataire->IdPAD."_".$request->type.".".$extension;
                $nom_file=$name;
                $destinationPath=MyApp::PATH_ALLOCATAIRES.$allocataire->IdPAD; 
                $path = $file->storeAs("/public".$destinationPath, $nom_file);
                if($path) {
                    $document=$this->setData($request,"",$nom_file,$destinationPath);
                }
            } else {
                Session::flash('danger', $msg);
                Redirect::back()->withErrors(['msg'=>"Document trop gros, il ne doit pas depasser 2Mo"]); 
            }
        } else {
            return Redirect::back()->withErrors(['msg'=>"Il faut choisir un fichier"]);
        }
        if($request->mode_frame) {
            Session::put("onglet_allocataire","o_documents");
            Session::flash('close_pop', "Document ajouté");
            return Redirect::to('allocataires_show_documents_pop/'.$document->id);
        }
        $msg="Le Document ".$document->nom." a été créé";
        Session::flash('message', $msg);
        return Redirect::to('documents');
    }
 

    public function edit($id,$mode="edit",$mode_frame=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($mode=="edit") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DOC_MAJ")) return redirect('home');
        else if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DOC_VISU")) return redirect('home');

        $document = Document::find($id);
        $types_documents=MyApp::getZBase("DOC_TYPES");
        return View::make('documents.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode"=>$mode,
            "mode_frame"=>$mode_frame,
            "document" => $document,"types_documents" => $types_documents
        ]);
    }
 
    public function edit_pop($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        return $this->edit($id,"edit",'true');
    }

    public function show($id)
    {
        dd("show");
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit($id,"show");
    }

    public function show_pop($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit($id,"show",'true');
    }

    public function update($id,DocumentRequest $request)
    {
        $document = $this->setData($request,$id,"","");
        if($request->mode_frame) {
            Session::put("onglet_allocataire","o_documents");
            Session::flash('close_pop', "Document modifié");
            return Redirect::to('allocataires_show_documents_pop/'.$document->id);
        }
        $msg="Le Document ".$document->nom." a été mis à jour";
        Session::flash('message', $msg);
        return Redirect::to('documents');
    }
 
    public function delete_pop($id)
    {
        $document = Document::find($id);
        return $this->destroy($id,$document->id_allocataire);
    }

    public function destroy($id,$id_allocataire="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DOC_SUP")) return redirect('home');

        $document = Document::find($id);
        if(env('APP_ENV')=='developpement') $path="../storage/app/public";
        else $path="./storage";
        $destinationPath=$path.$document->path;
        $url=$destinationPath."/".$document->nom_file;
        if(file_exists($url)) unlink($url);
        Document::destroy($document->id);
        if($id_allocataire) {
            Session::put("onglet_allocataire","o_documents");
            Session::flash('close_pop', "close");
            return Redirect::to('allocataires_add_documents_pop/'.$id_allocataire);
        }
        return Redirect::to('documents');
    }
 
    public function setData($request,$id="",$nom_file="",$path="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($id=="") {
            $document =  new Document;
            $document->nom_file  = $nom_file; 
            $document->path = $path; 
        }
        else $document = Document::find($id);      
        $document->id_allocataire = ($request->id_allocataire)?$request->id_allocataire:null;
        $document->id_famille = ($request->id_famille)?$request->id_famille:null;
        $document->type = $request->type; 
        $document->description = $request->description; 
        $date=$request->date;
        $document->date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $document->save();

        return $document;
    }


    public function autocomplete_allocataire(AllocataireAutoRequest $request)
    { 
        //$associate[]=["id"=>'AAA',"value"=>'Aucun'];
        //return json_encode($associate);
        $param = $request->term;
        $associate = array();
        $sql="select id ,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";
        $search    = DB::select($sql);

        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }
}