<?php namespace App\Http\Controllers\Editions;


use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\VersementPrepa;
use App\Models\Versement;
use App\Models\MyApp;
use View;
use App\Http\Controllers\Controller;

use Codedge\Fpdf\Fpdf\Fpdf;

class PDF_attestations extends FPDF
{
    var $Titre="";
    var $Beneficiaire="";
    var $Directeur="";
    var $Date="";
    var $Service="";
    var $Adresse="";
    var $AdresseBas="";

    function set_Titre($titre) { $this->Titre=$titre;}
    function set_Allocataire($allocataire) { $this->allocataire=Allocataire::find($allocataire);}
    function set_user($user) { $this->user=$user;}
    function set_Date($Date) { $this->Date=$Date;}
    function set_Service($Service) { $this->Service=$Service;}
    function set_Adresse($Adresse) { $this->Adresse=$Adresse;}
    function set_AdresseBas($AdresseBas) { $this->AdresseBas=$AdresseBas;}

    public function setParametres()
    {
        //Paramètres
        $this->Directeur=MyApp::getParam("EDI_DIRECTEUR");

        $this->Date = date('d/m/Y');
    }

    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode(""),"T",0,'L');
        $this->Cell(100,7,$this->AdresseBas,"T",0,'C');
        $this->Cell(42,7,$this->PageNo(),"T",0,'R');
    }

    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;
        //Logo
        $this->Image('./img/prefet.jpg',$img_x,$img_y,30);
        $img_x+=30;$img_y=5;
        $this->Image('./img/at_wallis_futuna.png',$img_x,$img_y,30);
        $this->ln(30);
        $this->SetFont('Arial','B',10);
        $h=4;
        $this->Cell(200,$h,mb_convert_encoding($this->Service, 'ISO-8859-1',"UTF-8"),0,1,'L');
        $this->SetFont('Arial','',9);
        $this->MultiCell(150,4,mb_convert_encoding($this->Adresse, 'ISO-8859-1',"UTF-8"),'','L');
        $this->ln(15);

        //Titre Service
        $this->SetFont('Arial','B',13);
        $this->MultiCell(200,7,mb_convert_encoding($this->Titre, 'ISO-8859-1',"UTF-8"),'','C');
        //Titre
        $this->SetFont('Arial','',14);
        $this->ln(0);
        $this->Cell(200,$h,mb_convert_encoding($this->Date, 'ISO-8859-1',"UTF-8"),0,0,'C');
    }


    function ListeEnfant($enfants)
    {
        //Largeurs des colonnes
        $w=array(65,80,32);
        $depX=20;
        $this->SetX($depX);
        $this->SetFillColor(234, 228, 221);
        $this->SetFont('Arial','B',8);
        $this->Cell($w[0],7,mb_convert_encoding("NOM", 'ISO-8859-1',"UTF-8"),'1',0,'L',1);
        $this->Cell($w[1],7,mb_convert_encoding("PRENOM", 'ISO-8859-1',"UTF-8"),'1',0,'L',1);
        $this->Cell($w[2],7,mb_convert_encoding("DATE DE NAISSANCE", 'ISO-8859-1',"UTF-8"),'1',1,'C',1);
        $this->SetFont('Arial','',8);
        foreach($enfants as $enfant) {
            $this->SetX($depX);
            $this->Cell($w[0],7,mb_convert_encoding($enfant->nom_naissance, 'ISO-8859-1',"UTF-8"),'1',0,'L');
            $this->Cell($w[1],7,mb_convert_encoding($enfant->prenom, 'ISO-8859-1',"UTF-8"),'1',0,'L');
            $this->Cell($w[2],7,mb_convert_encoding($enfant->DateNaissance, 'ISO-8859-1',"UTF-8"),'1',1,'C');
        } 

    }
}

class EditionsAttestationsPaiementController extends Controller {
    public function imprime($type_aide,$allocataire_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $allocataire = Allocataire::find($allocataire_id);
        if(!$allocataire) exit();
        //Recherche du dernier versement
        $versement=$allocataire->getLastVersement($type_aide);
        /*
        $versement=Versement::where("id_allocataire","=",$allocataire_id)
            ->where("type","=",$type_aide)
            ->orderby("date","DESC")->first();
        */
        if(!$versement) exit();
        $nom_allocataire=$allocataire->EtatCivilLong." ".$allocataire->NomComplet;
        $adresse_allocataire=$allocataire->getAdresseComplete2("\n");
        $ile_elle=($allocataire->sexe=="M")?"il":"elle";

        $libelle_aide=MyApp::TYPES_AIDES[$type_aide];
        $date=$versement->date;
        $annee=substr($versement->dateUS,0,4);
;
        $mois=MyApp::MOIS_NUM[substr($versement->dateUS,5,2)];

        $fpdf = new PDF_attestations();
        $fpdf->setParametres();
        $fpdf->set_Allocataire($allocataire_id);
        $fpdf->set_user($user);
        $fpdf->set_Date("Mois : ".$mois." - Année : ".$annee);
        $fpdf->set_Adresse(MyApp::getParam('EDI_ADRESSE_BLOC'));
        $fpdf->set_Service(MyApp::getParam('EDI_NOM_SERVICE'));

        $titre = "ATTESTATION DE PAIEMENT";
        $nom_fichier = 'ATT_'.$type_aide;
        $text=MyApp::getParam('EDI_ATTPMT_'.$type_aide);

        $text=str_replace("{NOM_DIRECTEUR}",$fpdf->Directeur,$text);
        $text=str_replace("{ALLOC_NOM_COMPLET}",$nom_allocataire,$text);
        $text=str_replace("{ALLOC_ADRESSE}",$adresse_allocataire,$text);
        $text=str_replace("{ALLOC_DATE_NAISS}",$allocataire->DateNaissance,$text);
        $text=str_replace("{MONTANT}",$versement->montant,$text);
        $text=str_replace("{IL-ELLE}",$ile_elle,$text);
        $PosListe=strpos($text,"{ENFANTS_LISTE}");

        
        //Si avec liste texte coupé en 2 au niveau de {ENFANTS_LISTE}
        $text2="";$enfants=[];
        if($PosListe) { 
            $text2=substr($text,$PosListe+strlen("{ENFANTS_LISTE}"));
            $text=substr($text,0,$PosListe);
            $enfants=$allocataire->getEnfantsAAE();
        }
        
        
        
        $h=7;$depX=20;
        $fpdf->set_Titre($titre);
        $fpdf->AddPage();

        //Mise en forme du corps
        $fpdf->ln(20);
        $fpdf->SetFont('Arial','',11);
        $fpdf->SetX($depX);
   
        $fpdf->MultiCell(180,7,mb_convert_encoding($text, 'ISO-8859-1',"UTF-8"),'','L');
        if($PosListe) $fpdf->ListeEnfant($enfants);    
        
        $fpdf->SetFont('Arial','',11);
        $fpdf->SetX($depX);
        if($text2) $fpdf->MultiCell(180,7,mb_convert_encoding($text2, 'ISO-8859-1',"UTF-8"),'','L');    


        //Lieu
        $fpdf->ln(10);
        $fpdf->SetX($depX);
        $fpdf->Cell(80,$h,mb_convert_encoding("Mata'Utu le ".date('d/m/Y'), 'ISO-8859-1',"UTF-8"),"",0,'L');
        $fpdf->SetFont('Arial','B',11);
        $fpdf->Cell(90,$h,mb_convert_encoding($fpdf->Directeur, 'ISO-8859-1',"UTF-8"),"",2,'R');
        $fpdf->SetFont('Arial','',11);
        $fpdf->Cell(90,$h,mb_convert_encoding("Directeur du SITAS ", 'ISO-8859-1',"UTF-8"),"",0,'R');

        $fpdf->Output($nom_fichier."_".$allocataire_id.".pdf","I");

        exit();
    }



    


}
