<?php namespace App\Http\Controllers\Editions;


use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\VersementPrepa;
use App\Models\Versement;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
use DB;
use App\Http\Controllers\Controller;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsVersementsListeController extends Controller {
    /**
     * Liste des versements
     */
    //Contribution Sociale de Retraite
    public function imprimer_csr($num_imp="") {return $this->imprimer($num_imp,"CSR"); }
    //Aide à l'enfant
    public function imprimer_aae($num_imp="") {return $this->imprimer($num_imp,"AAE"); }
    //Prime a la naissance
    public function imprimer_pan($num_imp="") {return $this->imprimer($num_imp,"PAN"); }
    //Filet Social
    public function imprimer_fso($num_imp="") {return $this->imprimer($num_imp,"FSO"); }
    //Dépedance
    public function imprimer_agd($num_imp="") {return $this->imprimer($num_imp,"AGD"); }
    //GHandicap
    public function imprimer_aph($num_imp="") {return $this->imprimer($num_imp,"APH"); }


    public function imprimer($num_imp,$type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        $num_imp_PAD=str_pad($num_imp,4, "0", STR_PAD_LEFT);
        $date=date('d/m/Y');
        $titre="";
        $titre="Versement ".MyApp::PREFIXE_AIDES[$type_aide].MyApp::TYPES_AIDES[$type_aide];
        $titre_doc=$titre;
        $nom_fichier="versements_".$type_aide."_".date("Y_m_d").$num_imp_PAD.".pdf";
        $font="Arial";
        $font_size=8;

        $titre.=" N°".$num_imp_PAD;
        $titre_doc.=" N°".$num_imp_PAD;
        $total=0;
        
        $versements=Versement::where('type','=',$type_aide)
            ->where('num_imp','=',$num_imp)
            ->orderby('destinataire_nom')->orderby('destinataire_prenom')
            ->get(); 



        foreach($versements as $versement) $total+=$versement->montant_r+$versement->montant; 


        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AliasNbPages();
        $fpdf->SetAutoPageBreak(false,5);
        $fpdf->AddPage("L");
        //Titre Service
        
        //Titre
        $depX=5;
        $fpdf->SetFont($font,'',14);
        $fpdf->SetX($depX);
        $fpdf->SetFillColor(135,206,250);
        $this->Header($fpdf,$titre_doc);

        //Liste des Versements
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',$font_size);
        $w=array(9,59,6,13,20,10,18,28,40,40,15,15,15);
        $col_def=array('N°'=> $w[0],'Allocataire' => $w[1],'Ile' => $w[2],'District' => $w[3],
            "Village" => $w[4],"NbEnf" =>$w[5],"Naissance" =>$w[6],"Bque/ModePmt" =>$w[7],
            "Titulaire" =>$w[8],"Compte" =>$w[9],"Rappel" =>$w[10],"Montant" =>$w[11],"Total" =>$w[12]);    

        $h=6;$h2=8;$cadre="";
        $nb_ligne=0;$nbmax_ligne=13;
        $fpdf->SetFont($font,'',7);
        $fpdf->ln($h);
        $fpdf->SetX($depX);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
        $fpdf->ln($h);
        foreach($versements as $versement) {
            $bordure="BLR";$k=0;
            $nom=$versement->getAllocataireNomCompletReduit(35);
            $banque=($versement->mode_versement!="VIR")?"NUMERAIRE":$banque=$versement->BanqueNom;
            if($fpdf->GetY()>190) {
                $this->Footer($fpdf,$user);
                $fpdf->AddPage("L");
                $this->Header($fpdf,$titre_doc);
                $fpdf->ln($h);
                $fpdf->SetX($depX);
                foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
                $fpdf->ln($h);
                
            }
            $titulaire=$versement->titulaire;
            if(strlen($titulaire)>20) $titulaire=substr($titulaire,0,25);
            $fpdf->SetX($depX);
            $fpdf->Cell($w[$k++],$h,$versement->AllocataireIdPAD,$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($nom, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->ile, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->district, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->village, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->nb_enf, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($versement->AllocataireDateNaissance, 'ISO-8859-1',"UTF-8"),$bordure,0,'C');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($banque, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,mb_convert_encoding($titulaire, 'ISO-8859-1',"UTF-8"),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$versement->compte,$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$versement->montant_r,$bordure,0,'R');
            $fpdf->Cell($w[$k++],$h,$versement->montant ,$bordure,0,'R');
            $fpdf->Cell($w[$k++],$h,$versement->montant_r+$versement->montant ,$bordure,1,'R');
            $nb_ligne++;
        }
    
        //TOTAL
        $fpdf->SetFont($font,'B',14);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0]+$w[1]+$w[2]+$w[3]+$w[4]+$w[5]+$w[6]+$w[7]+$w[8]+$w[9],$h2,"TOTAL","LRTB",0,'C');
        $fpdf->Cell($w[10]+$w[11]+$w[12],$h2,number_format($total,0,","," ")." XPF","LRTB",0,'C');

        //Fin
        $this->Footer($fpdf,$user);
        $fpdf->Output($nom_fichier,"I");
        exit(); 
    }


    function Header($fpdf,$titre_doc)
    {
        //Titre
        $fpdf->SetFont("Arial",'',14);
        $fpdf->SetX(35);
        //$fpdf->SetFillColor(135,206,250);
        $fpdf->Cell(240,7,utf8_decode($titre_doc),"",0,'C');
        $fpdf->SetFont("Arial",'',7);
        $fpdf->Cell(10,7,date("d/m/Y"),"",1,'L',"");
    }

    function Footer($fpdf,$user)
    {
        //Titre
        $fpdf->SetFont("Arial",'',7);
        $fpdf->SetY(205);
        $fpdf->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $fpdf->Cell(60,7,mb_convert_encoding("Edité par ".$user->name, 'ISO-8859-1',"UTF-8"),"T",0,'L');
        $fpdf->Cell(178,7,MyApp::SITAS_ADRESSE,"T",0,'C');
        $fpdf->Cell(50,7,$fpdf->PageNo().'/{nb}',"T",0,'R');
    }



}