<?php namespace App\Http\Controllers\Editions;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Auth\AuthController;
use App\Models\Banque;
use App\Models\Allocataire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Versement;
use App\Models\Parametre;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Mail;


class ExportVersementsController extends Controller {
    private $menu_home="versements";
    private $menu='versements_ter';
    private $submenu='versements_csr';
    

    public function __construct()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

    }


    /* ****************************** */
    /* TRESOR PUBLIC */
    /* ****************************** */

    //Contribution Sociale de Retraite
    public function index_export_csr($num_imp) {return $this->index_export($num_imp,"CSR");}
    //Aide à l'enfant
    public function index_export_aae($num_imp) {return $this->index_export($num_imp,"AAE");}
    //Prime a la naissance
    public function index_export_pan($num_imp) {return $this->index_export($num_imp,"PAN");}
    //Filet Social
    public function index_export_fso($num_imp) {return $this->index_export($num_imp,"FSO");}
    //Dépendance
    public function index_export_agd($num_imp) {return $this->index_export($num_imp,"AGD");}
    //Handicap
    public function index_export_aph($num_imp) {return $this->index_export($num_imp,"APH");}


    //Page export générique
    public function index_export($num_imp,$type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $this->submenu="versements_".strtolower($type_aide);
        $versements=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)->get();
        return View::make('versements.export.export_fichier_TP', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type_aide'=>$type_aide,
            'num_imp'=>$num_imp,
            'versements' => $versements,
        ]);
    }


    /* ************************* */
    /* Exportation du fichier Tp */
    /* ************************* */
    //Contribution Sociale de Retraite
    public function export_csr(Request $request,$num_imp) {return $this->export($request,$num_imp,"CSR");}
     //Aide à l'enfant
    public function export_aae(Request $request,$num_imp){return $this->export($request,$num_imp,"AAE");}
     //PRime a la naissance
     public function export_pan(Request $request,$num_imp){return $this->export($request,$num_imp,"PAN");}
     //Filet Social
     public function export_fso(Request $request,$num_imp){return $this->export($request,$num_imp,"FSO");}
     //Dépendance
     public function export_agd(Request $request,$num_imp){return $this->export($request,$num_imp,"AGD");}
     //Handicap
     public function export_aph(Request $request,$num_imp){return $this->export($request,$num_imp,"APH");}


    /* Exportation du fichier Tp générique */
    public function export(Request $request,$num_imp,$type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $this->submenu="versements_".strtolower($type_aide);
        $date=$request->date_export;
        //$designation=$request->designation;
        //$compte_sitas=$request->compte;
        $date=substr($date,0,2).substr($date,3,2).substr($date,8,2);
        $versements=Versement::where('type','=',$type_aide)->where('num_imp','=',$num_imp)
            ->whereNotnull("id_banque") //SAUF Aucune, Aucune Futuna, BWF
            ->where("mode_versement",'=',"VIR") //SAUF Aucune, Aucune Futuna, BWF
            ->get();
        $date_deb=DB::table('versements')->where('type','=',$type_aide)->where('num_imp','=',$num_imp)
            ->orderby('date')->first()->date;

        $nom_file="";
        $nb_lignes=0;
        //Génération du fichier
        $nomfile="SITAS_versements_".strtolower($type_aide)."_".substr($date_deb,0,6).".txt";;
        $path="./upload/tresor_public/".strtolower($type_aide);
        //création du dossier
        if(!file_exists($path)) {
            mkdir($path,'0777',true);
            chmod($path, '0755');
        }
        
        if(!file_exists($path)) {
            $message_err="Impossible de créer le fichier.";
        } else {
            $path_nom_file=$path."/".$nomfile;
            //ecriture du fichier
            $nb_lignes=$this->ecriture_file_complet($path_nom_file,$versements,$date); 
        }
        $t_email=array();
        return View::make('versements.export.export_fichier_TP', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type_aide'=>$type_aide,
            'nom_file'=>$nomfile,
            'path_nom_file'=>$path_nom_file,
            'nb_lignes'=>$nb_lignes,
            'versements' => $versements,
            'num_imp' => $num_imp,
            't_email' => $t_email,
        ]);
    }

    /* Génération des toutes les lignes */
    public function ecriture_file_complet($path_nom_file,$versements,$date)
    {
        $fl="\r\n";
        $fp = @fopen($path_nom_file, 'w');

        if(!$fp) return false;

        //ecriture des lignes
        $j=0;
        $montant_total=0;
        $nb_lignes_total=count($versements);

        $line="";$j=1;
        foreach ($versements as $versement) {
            $montant_total+=$versement->montant;
            $line=$this->getLigne_complet($versement,$j,$date);
            fwrite($fp, $line.$fl);
            $j++;
        }
        fclose($fp);
        return $j;
    }

    /* Génération d'unelignes */
    public function getLigne_complet($versement,$i,$date)
    {
        //EX:
        //XXXXX0000000002197NXXX9811000010071987000000000121416  PAIERIE DE WALLIS ET    1TAUHAVILI Mikaele             X                         00100000
        $allocataire=Allocataire::find($versement->id_allocataire);

        //Banque
        $banque=Banque::find($versement->id_banque);
        $max_nom_banque=24;
        $nom_banque=utf8_encode(strtoupper($this->str_to_noaccent($banque->nom)));
        if(strlen($nom_banque)>$max_nom_banque) $nom_banque=substr($nom_banque,0,$max_nom_banque);
        $compte_client=$versement->compte;
        $banque_cli=substr($compte_client,4,5); //IBAN-Banque
        $guichet_cli=substr($compte_client,9,5); //IBAN-Guichet
        $compte_cli=substr($compte_client,14,11); //IBAN-Compte
        
        $cle_cli=substr($compte_client,25,2); //IBAN-Clé
        //NOM et PRENOM
        $max_nom_alloc=30;
        $nom=$this->str_to_noaccent($versement->destinataire_nom);
        $prenom=$this->str_to_noaccent($versement->destinataire_prenom);
        $nom_allocataire=utf8_encode(strtoupper($nom)." ".$prenom);
        if(strlen($nom_allocataire)>$max_nom_alloc) $nom_allocataire=substr($nom_allocataire,0,$max_nom_alloc);

        
        $line="";
        // - (zone 01-04) Les 4 premiers caractères (alphanumériques) peuvent être X ou autre (XXXX pour la paye du Territoire)
        $line.="XXXX";
        //- (zone 05-19) Les 15 caractères suivants (alphanumériques) peuvent être un numéro d'allocataire (sur 15 caractères alphanumériques).
        $line.=str_pad($allocataire->id, 15, "0", STR_PAD_LEFT);
        //- (zone 20-24) Les 5 caractères suivants (alphanumériques) peuvent être X ou autre (XXX98 pour la paye du Territoire)
        $line.="XXX98";
        //- (zone 25-26) Le code moyen de paiement. Il est à "11" sur le fichier paye du Territoire. Il existe dans le protocole les codes "22" (virements bancaires) "33" (Fonds particuliers) ou 44 (divers)
        $line.="11";
        //- (zone 27-30) Valeur 0000
        $line.="0000";
        //- (zone 31-35)  Code banque (5 caractères numériques)
        $line.=$banque_cli;
        //- (zone 36-40) Code guichet (5 caractères numériques)
        $line.=$guichet_cli;
        //- (zone 41-51) Numéro du compte (11 caractères alpha-numériques)
        $line.=$compte_cli;
        //- (zone 52-53) clé RIB (2 caractères numériques)
        $line.=$cle_cli;
        //- (zone 54-55) zone non utilisée (2 caractères à espace)
        $line.="  ";
        //- (zone 56-79) Libellé de l'établissement bancaire conforme au répertoire des guichets permanents de la Banque de France (24 caractères alpha-numériques)
        
        $line.=str_pad($nom_banque, 24, " ", STR_PAD_RIGHT);
        //- (zone 80) = Etat civil = 1: M.; 2: Mme; 3: Mle
        $line.=($allocataire->EtatCivilCode)?$allocataire->EtatCivilCode:"3";
        //- (zone 81-110) Nom et prénom (30 caractères alpha-numériques)
        $line.=str_pad($nom_allocataire,30, " ", STR_PAD_RIGHT);
        //- (zone 111) = code monnaie = X = Francs Pacifique
        $line.="X";
        //- (zone 112-132) = zone non utilisée = zone à espaces
        $line.=str_pad(" ",25, " ", STR_PAD_LEFT);
        //- (zone 133-144) = Montant net à payer
        $line.=str_pad($versement->montant+$versement->montant_r,8, "0", STR_PAD_LEFT);

        return $line;
    }

    /* ****************** */
    /* Fonctions communes */
    /* ****************** */

    function str_to_noaccent($str)
    {
        $url = $str;
        $url = preg_replace('#Ç#', 'C', $url);
        $url = preg_replace('#ç#', 'c', $url);
        $url = preg_replace('#è|é|ê|ë#', 'e', $url);
        $url = preg_replace('#È|É|Ê|Ë#', 'E', $url);
        $url = preg_replace('#à|á|â|ã|ä|å#', 'a', $url);
        $url = preg_replace('#@|À|Á|Â|Ã|Ä|Å#', 'A', $url);
        $url = preg_replace('#ì|í|î|ï#', 'i', $url);
        $url = preg_replace('#Ì|Í|Î|Ï#', 'I', $url);
        $url = preg_replace('#ð|ò|ó|ô|õ|ö#', 'o', $url);
        $url = preg_replace('#Ò|Ó|Ô|Õ|Ö#', 'O', $url);
        $url = preg_replace('#ù|ú|û|ü#', 'u', $url);
        $url = preg_replace('#Ù|Ú|Û|Ü#', 'U', $url);
        $url = preg_replace('#ý|ÿ#', 'y', $url);
        $url = preg_replace('#Ý#', 'Y', $url);

        return ($url);
    }

}



