<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Sipre\SipreBanque;
use App\Models\Sipre\SipreBeneficiaire;
use App\Models\Sipre\SipreBeneficiaireBanque;
use App\Models\Sipre\SipreEnfant;
use App\Models\Allocataire;
use App\Models\AllocataireCompte;
use App\Models\Banque;
use App\Models\Famille;
use App\Models\FamilleMembre;
use App\Models\FamilleEnfant;
use App\Models\Village;
use App\Models\User;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\AllocataireRequest;
use App\Http\Requests\AllocataireAutoRequest;
use Illuminate\Http\Request;
use App\Models\Parametre;
use App\Http\Controllers\Logs;


class ImportationsController extends Controller {

    private $menu_home="importations";
    private $menu='importations';
    private $submenu='importation_aae';

    public function index($t_status,$type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $title="Bénéficiaires des Aides Sociales";

        $sipre_beneficiaires=[];
        $sipre_beneficiaires_temp = SipreBeneficiaire::whereIn('statut',$t_status)->get();
        foreach($sipre_beneficiaires_temp as $beneficiaire) {
            //if (($type!="AAE") || (($type=="AAE") && ($beneficiaire->NbEnfantsAAE)>0) ) {
                $sipre_beneficiaires[]=$beneficiaire;
            //}
        }
        $t_lignes = DB::connection('mysql2')->table('beneficiaires')->select('id')->get();
        $liste_aides=MyAPP::getListeAides();
        
        return View::make('importations.index_sipre_beneficiaires', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type' => $type,
            'sipre_beneficiaires' => $sipre_beneficiaires,
            't_lignes' => $t_lignes,
        ]);
    }

    public function index_aae()
    {
        $type="AAE";
        $t_status=["S","SAU","SRB"];
        $this->submenu="importation_aae";
        return $this->index($t_status,$type);
    }

    public function index_csr()
    {
        $type="CSR";
        $t_status=["SAA","SAR","SAV"];
        $this->submenu="importation_csr";
        return $this->index($t_status,$type);
    }

    public function import(Request $request)
    {
        $liste_id=$request->list_check;
        $type=$request->type;
        $t_id=explode(";",$liste_id);
        $t_id_new_allocataire=[];
        $t_result=["allocataires"=>0,"conjoints"=>0,"enfants"=>0,"familles"=>0,"banques"=>0,"comptes"=>0,"list_id"=>""];
        foreach($t_id as $key=>$value) {
            $beneficiaire=SipreBeneficiaire::find($value);
            $allocataire=Allocataire::where('id_cpswf','=',$value)->first();
            if($beneficiaire && !$allocataire) {
                $t_result=$this->createAllocataire($beneficiaire,$type,$t_result);
            }
        }
        if($t_result["allocataires"]>0) {
            $msg="Création de :";
            $msg.="<ul>";
            $msg.="<li>".$t_result["allocataires"]." allocataires";
            $msg.="<li>".$t_result["conjoints"]." conjoints";
            $msg.="<li>".$t_result["enfants"]." enfants";
            $msg.="<li>".$t_result["familles"]." familles";
            $msg.="<li>".$t_result["banques"]." banques";
            $msg.="<li>".$t_result["comptes"]." comptes";
            $msg.="</ul>";
            //$msg.="<br/>".$t_result["list_id"];

        } else $msg="Aucun allocataire de créé créé";

        Session::flash('message', $msg);
        return redirect()->back();
    }
    
    /* Creation allocataire à partir du bénéficiaire SIPRE */
    public function createAllocataire($beneficiaire,$type,&$t_result) {
        $famille="";
        $allocataire_conjoint="";

        //Création de l'allocataire
        $allocataire=$this->setAllocataire($beneficiaire,$t_result);
        //Ajout des Aides selon le type.. si elle n'existe pas déjà
        $t_aides=explode(",",$allocataire->types_aides);
        if(!in_array($type,$t_aides)) {
            $allocataire->types_aides.=(($allocataire->types_aides=="")?"":",").$type;
            $allocataire->save();
        }

        //Création du conjoint et famille
        if($beneficiaire->conjoint) {
            $conjoint=SipreBeneficiaire::find($beneficiaire->conjoint);
            $allocataire_conjoint=Allocataire::where('id_cpswf','=',$conjoint->id)->first();
            if(!$allocataire_conjoint) {
                $allocataire_conjoint=$this->setConjoint($conjoint,$t_result);
                //SI conjoint alors famille
                if($allocataire_conjoint) {
                    $famille=$this->setFamille($allocataire->id,$allocataire_conjoint->id,$t_result);
                    $allocataire->setFamille($famille->id);
                    $allocataire_conjoint->setFamille($famille->id);
                }
            }
        }
        //Création des enfants et famille (si pas conjoint)
        $enfants=$beneficiaire->getEnfants();
        if($enfants) {
            //SI enfant et famille existe pas alors famille
            if(!$famille) {
                $id_conjoint=isset($allocataire_conjoint->id)?$allocataire_conjoint->id:null;
                $famille=$this->setFamille($allocataire->id,$id_conjoint,$t_result);
                $allocataire->setFamille($famille->id);
                
            }
            if($famille) 
                foreach($enfants as $enfant) 
                    $this->setEnfant($allocataire,$allocataire_conjoint,$enfant,$famille,$t_result);

        }

        //Création de la banque
       
        $this->setCompte($allocataire,$beneficiaire,$t_result);

        return $t_result;
    }

    public function setCompte($allocataire,$beneficiaire,&$t_result) {
        $allocataire_compte="";
        $beneficiaire_banque=SipreBeneficiaireBanque::where("id_benef","=",$beneficiaire->id)->where("actif","=","1")->orderby("id","DESC")->first();
        //Creation de la banque si besoin
        if($beneficiaire_banque) {
            $sipre_banque=SipreBanque::where('id','=',$beneficiaire_banque->banque_id)->first();
            if(!$sipre_banque) return "";;
            $banque = Banque::where('nom','like',$sipre_banque->nom)->first();
            if(!$banque) $banque=$this->setBanque($sipre_banque,$t_result);

            //CReation de  AllocataireCompte
            $allocataire_compte =  new AllocataireCompte;
            $allocataire_compte->id_banque = $banque->id;
            $allocataire_compte->id_allocataire = $allocataire->id;
            $allocataire_compte->IBAN_pays = $beneficiaire->IBAN_pays;
            $allocataire_compte->IBAN_cle = $beneficiaire->IBAN_cle;
            $allocataire_compte->IBAN_banque = $beneficiaire->IBAN_banque;
            $allocataire_compte->IBAN_guichet = $beneficiaire->IBAN_guichet;
            $allocataire_compte->IBAN_compte = $beneficiaire->IBAN_compte;
            $allocataire_compte->IBAN_clerib = $beneficiaire->IBAN_clerib;
            $allocataire_compte->actif = 1;
            $allocataire_compte->save();
            $t_result["comptes"]++;
        }
        return $allocataire_compte;
    }

    //Nouvelle Famille
    public function setAllocataire($beneficiaire,&$t_result) {
        //Données de base allocataire
        $allocataire =  new Allocataire;
        $allocataire->id_cpswf = $beneficiaire->id;
        $allocataire->types_aides = "";
        $allocataire->nom  = $beneficiaire->nom;
        $allocataire->nom_naissance  = "";
        $allocataire->prenom  = $beneficiaire->prenom;
        $sexe=null;
        if($beneficiaire->civilite=="Mr") $sexe="M";
        if(($beneficiaire->civilite=="Mme")||($beneficiaire->civilite=="Mll")) $sexe="F";
        $allocataire->sexe = $sexe;
        $allocataire->date_naissance = $beneficiaire->datenaiss;
        $allocataire->lieunaiss = $beneficiaire->lieunaiss;
        $id_village=$this->getVillage($beneficiaire->adresse);
        $allocataire->adresse = $beneficiaire->adresse;
        $allocataire->code_postal = $beneficiaire->code_postal;
        $allocataire->boite_postale  = null;
        $allocataire->id_village = $id_village;
        $allocataire->mobile = null;
        $allocataire->tel = $beneficiaire->tel;
        $allocataire->email = $beneficiaire->email;
        $allocataire->obs =  $beneficiaire->obs_vers;
        $allocataire->statut_dossier = "ACT";
        $allocataire->statut_conjugal = "";
        $allocataire->statut = "";
        $allocataire->verrou = 0;
        $allocataire->save();
        $t_result["allocataires"]++;
        $t_result["list_id"].=(($t_result["list_id"]=="")?"":",").$allocataire->id;
        return $allocataire;
    }


    //Nouvelle Banque
    public function setBanque($sipre_banque,&$t_result) {
        $banque= new Banque;
        $banque->nom = $sipre_banque->nom;
        $banque->adresse = $sipre_banque->adresse;
        $banque->cp = $sipre_banque->cp;
        $banque->ville = $sipre_banque->ville;
        $banque->tel = $sipre_banque->tel;
        $banque->email = $sipre_banque->email;
        $banque->contact = $sipre_banque->contact;
        $banque->agence = $sipre_banque->agence;
        $banque->bic = $sipre_banque->bic;
        $banque->save();
        $t_result["banques"]++;
        return $banque;
    }


    //Nouvelle Famille
    public function setFamille($id_titulaire,$id_conjoint,&$t_result) {
        $famille =  new Famille;
        $famille->id_titulaire=$id_titulaire;
        $famille->id_conjoint=$id_conjoint;
        $famille->save();
        $t_result["familles"]++;
        return $famille;
    }

    //Nouvel enfnat
    public function setEnfant($allocataire,$allocataire_conjoint,$enfant,$famille,&$t_result) {
        $id_parent1=null;$id_parent2=null;
        $parent1=SipreBeneficiaire::find($enfant->parents1);
        $parent2=SipreBeneficiaire::find($enfant->parents2);
        if($parent1) {
            if($parent1->id==$allocataire->id_cpswf) $id_parent1=$allocataire->id;
            else if(isset($allocataire_conjoint->id_cpswf) && ($parent1->id==$allocataire_conjoint->id_cpswf)) $id_parent1=$allocataire_conjoint->id;
        }
        if($parent2) {
            if($parent2->id==$allocataire->id_cpswf) $id_parent2=$allocataire->id;
            else if(isset($allocataire_conjoint->id_cpswf) && ($parent2->id==$allocataire_conjoint->id_cpswf)) $id_parent2=$allocataire_conjoint->id;
        }
        $allocataire_enfant =  new Allocataire;
        $allocataire_enfant->id_parent1 = $id_parent1;
        $allocataire_enfant->id_parent2 = $id_parent2;
        $allocataire_enfant->id_cpswf = $enfant->id;
        $allocataire_enfant->id_famille = $famille->id;
        $allocataire_enfant->nom  = $enfant->nom;
        $allocataire_enfant->nom_naissance  = null;
        $allocataire_enfant->prenom  = $enfant->prenom;
        $allocataire_enfant->sexe =  $enfant->sexe;
        $allocataire_enfant->date_naissance = $enfant->datenais;
        $allocataire_enfant->certificat_enfant = ($enfant->certif==9)?"6":$enfant->certif; //9= décédé, pas géré à la CPS
        $allocataire_enfant->statut_dossier = "ACT";
        $allocataire_enfant->statut_conjugal = null;
        $allocataire_enfant->statut = null;
        $allocataire_enfant->verrou = 0;
        $allocataire_enfant->save();
        $t_result["enfants"]++;
        
        //On associe l'enfant à la famille
        $famille_enfant =  new FamilleEnfant;
        $famille_enfant->id_famille = $famille->id;
        $famille_enfant->id_enfant = $allocataire_enfant->id;
        $famille_enfant->save();

        return $famille_enfant;
    }

    //Nouveau conjoint
    public function setConjoint($conjoint,&$t_result) {
        //Données de base allocataire
        $allocataire_conjoint =  new Allocataire;
        $allocataire_conjoint->id_cpswf = $conjoint->id;
        $allocataire_conjoint->nom  = $conjoint->nom;
        $allocataire_conjoint->nom_naissance  = "";
        $allocataire_conjoint->prenom  = $conjoint->prenom;
        $sexe=null;
        if($conjoint->civilite=="Mr") $sexe="M";
        if(($conjoint->civilite=="Mme")||($conjoint->civilite=="Mll")) $sexe="F";
        $allocataire_conjoint->sexe =  $sexe;
        $allocataire_conjoint->date_naissance = $conjoint->datenaiss;
        $allocataire_conjoint->lieunaiss = $conjoint->lieunaiss;
        $allocataire_conjoint->adresse = $conjoint->adresse;
        $allocataire_conjoint->code_postal = $conjoint->code_postal;
        $allocataire_conjoint->boite_postale  = null;
        $id_village=$this->getVillage($conjoint->adresse);
        $allocataire_conjoint->id_village = $id_village;
        $allocataire_conjoint->mobile  = null;
        $allocataire_conjoint->tel = $conjoint->tel;
        $allocataire_conjoint->email = $conjoint->email;
        $allocataire_conjoint->statut_dossier = "ACT";
        $allocataire_conjoint->statut_conjugal = null;
        $allocataire_conjoint->statut = null;
        $allocataire_conjoint->verrou = 0;
        $allocataire_conjoint->save();
        $t_result["conjoints"]++;

        return $allocataire_conjoint;
    }
    
    //Retour id district,id_village si village trouvé dans adresse
    public function getVillage($adresse) {
        //Adresse decodage
        $adresse=strtolower($adresse);
        $villages=Village::whereNotIn('nom',["MATA'UTU"])->orderby('nom','DESC')->get();; //Pour tester MALAEFOU avant MALAE
        foreach($villages as $village) {
            $nom=strtolower($village->nom);
            $nom=str_replace("'"," ",$nom);
            $adresse=str_replace("'"," ",$adresse);
            if(strpos($adresse,$nom)!==false) break;
        } 
        //dd($adresse." => ".(isset($village->id)?$village->id:""));
        if(!$village && (strpos($adresse,"MATA UTU"))) {
            $village=Village::where('nom',"like","%MATA%UTU%")->first(); //Si on a trouvé que mata'utu alors c'est MataUtu
        }
        if($village) return $village->id;
        return null;
    }
}
