<?php namespace App\Http\Controllers;

use Auth\AuthController;

use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Parametre;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Illuminate\Http\Request;

class ParametresController extends Controller {


    private $menu='taux';
    private $submenu='';
    private $menu_home='parametres';


    public function index_taux()
    {
        return $this->index("taux");
    }

    public function index_editions()
    {
        return $this->index("editions");
    }

    public function index_divers()
    {
        return $this->index("divers");
    }

    public function index($categorie)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->can("PAR_VISU")&&(!$user->hasRole("ADMINISTRATEUR"))) return;

        $this->menu=$categorie;
        $this->submenu=$categorie;
        $parametres = []; $t_parametres=[];$t_modules=[];
        $title="Paramètres de calcul";
        $module_libelle="";
        $parametres = Parametre::where("categorie","=",$categorie)->orderBy('ref')->orderBy('position')->get();
        foreach($parametres as $parametre) {
            $module=substr($parametre->ref,0,3);
            if(isset(MyApp::TYPES_AIDES[$module])) {
                $t_modules[$module]=MyApp::TYPES_AIDES[$module];
            } else {
                if($module=="EDI") $t_modules[$module]="Editions";
                if($module=="CPT") $t_modules[$module]="Général";
            }
            $t_parametres[$module][$parametre->id]=["type"=>$parametre->type,"ref"=>$parametre->ref,"categorie"=>$parametre->ref,
                        "info"=>$parametre->info,"value"=>$parametre->value];
        }

        return View::make('param.parametres.index', [
            'user' => $user,'menu_home' => $this->menu_home,'menu' => $this->menu,'submenu' => $this->submenu,
            'title' => $title,
            't_modules' => $t_modules,'t_parametres' => $t_parametres,
        ]);
    }

    
     


    public function show($categorie)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->can("PAR_VISU")&&(!$user->hasRole("ADMINISTRATEUR"))) return;

        $parametres = Parametre::where()->orderBy('position')->get();

        return $this->index("show");
        exit();
    }


    public function create()
    {
        return View::make('param.parametres.create');
    }

    public function store(Request $request)
    {
        return Redirect::to('/param/parametres');
    }


    public function edit($id)
    {
        $parametre = Parametre::find($id);
        return View::make('param.parametres.edit', [ 'parametre' => $parametres ]);
    }


    public function update(Request $request)
    {
        $parametres="";
        $msg="Aucune mise à jour effectuée";//Bienvenue sur la Nouvelle version de SYGI - Système de Gestion des Immatriculations de Wallis & Futuna
        $parametres=Parametre::all(); //sauf les dates $code=["MSG"];
        if($parametres) {
            foreach($parametres as $param) {
                $param->value = $request->{$param->reference."_value"};
                $param->save();
            }
            $msg="Mise à jour effectuée";
        }
        Session::flash('success', $msg);

        return redirect('/parametres');
    }


    public function submitPost(Request $request)
    {
        // We are collecting all data submitting via Ajax
        $save=false;
        $input = $request->all();
        $parametres=Parametre::where('ref','=',$request->field)->first();
        if($parametres) {
            $parametres->value = $request->value;
            $parametres->save();
            $save=true;
        }
        return json_encode($save);

        /*
        return json_encode($input);
        $field = $request->field;
        $value = $request->value;
        return $field.",".$value;
        return response()->json([
            "status" => true,
            "data" => $input
        ]);
        */
    }
}
