<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Log;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\AllocataireCompte;
use App\Models\Revision;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Redirect;
use View;


class RevisionsController extends Controller {
    private $menu_home="base";
    private $menu='';
    private $submenu='';

    public function index($type,$id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("REV_VISU")) return redirect('home');

        $titre="Liste des modifications effectuée sur ";
        $modele="";$revisions="";
        if($type=="allocataire") {
            $modele='Allocataire';
            $allocataire=Allocataire::find($id);
            $titre.=" l'allocataire ".$allocataire->NomComplet;
        }
        $revisions=Revision::where('revisionable_type','like','%'.$modele)->where('revisionable_id','=',$id)->whereNotIn('key',['created_at','updated_at'])->orderby('created_at','DESC')->get();
        
        return View::make('revisions.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'titre' => $titre,
            'revisions' => $revisions,
        ]);
    }

    public function index_comptes($id_alloc)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("REV_VISU")) return redirect('home');

        $titre="Liste modifications de comptes bancaires ";
        $revisions="";
        $modele='Allocataire';
        $allocataire=Allocataire::find($id_alloc);
        $titre.=" l'allocataire ".$allocataire->NomComplet;
        //Comptes bancaires
        $comptes=AllocataireCompte::where('id_allocataire','=',$id_alloc)->orderby('id','DESC')->get();


        return View::make('revisions.index_comptes', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'titre' => $titre,
            'comptes' => $comptes,
        ]);
    }
}
