<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\Village;
use App\Models\District;
use App\Models\Versement;
use App\Models\VersementEnfant;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Collection;
use Illuminate\Http\Request;
use View;
use DB;


class StatsController extends Controller {

    private $menu_home="analyses";
    private $menu='analyses_aae';
    private $submenu='tdb_aae';


    public function index($type_aide)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $title=MyApp::TYPES_AIDES[$type_aide];
        $this->menu=strtolower('analyses_'.$type_aide);
        $this->submenu=strtolower('tdb_'.$type_aide);
        $statistiques=new Collection();
        $versements=Versement::where('type','=',$type_aide)->orderBy('date','ASC')->get();
        $mois_old="";$nb_allocataires=0;$nb_enfants=0;$nb_versements=0;$montant=0;
        $t_data1=[];$t_data2=[];$t_label=[];
        $nb_versements_total=$versements->count();
        foreach($versements as $versement)
        {
            $nb_versements++;
            $nb_enfants+=$versement->nb_enf;
            $montant+=$versement->montant+$versement->montant_r;
            $mois=substr($versement->date,0,7);
           // echo $mois."!=".$mois_old."&&".$mois_old."<br/>";
            if( (($mois!=$mois_old)&&($mois_old!="")) || ($nb_versements==$nb_versements_total)) {
                $statistique=new Collection();
                $statistique->nb_enfants=$nb_enfants;
                $statistique->montant=$montant;
                $statistique->mois=$mois;
                $statistique->nb_allocataires=$nb_versements;
                $statistiques->push($statistique);
                $t_data1[]=$nb_versements;
                $t_data2[]=$montant;
                $t_label[]=$mois;
                $nb_versements=0;$nb_enfants=0;$montant=0;$nb_versements=0;
            }
            $mois_old=$mois;
        }

        $legende_data1="Allocataires";
        $legende_data2="Montants";

        return View::make('stats.index_data', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type_aide' => $type_aide,
            'statistiques' => $statistiques,
            'legende_data1' => $legende_data1,'legende_data2' => $legende_data2,
            't_data1' => $t_data1,'t_data2' => $t_data2,'t_label' => $t_label,

        ]);
    }
    //Aide à l'enfant
    public function index_aae($mois_aff="",$onglet=""){return $this->index_spec_aae($mois_aff,$onglet);}
    //Prime a la naissance
    public function index_pan($mois_aff="",$onglet=""){return $this->index("PAN");}
    //CSR
    public function index_csr($mois_aff="",$onglet=""){return $this->index_spec_csr($mois_aff,$onglet);}
    //CSR
    public function index_fso($mois_aff="",$onglet=""){return $this->index_spec_fso($mois_aff,$onglet);}


    //Aide à l'enfant
    public function index_graph_aae($annee=""){
        return $this->index_graph("AAE",$annee);
    }
    //Prime a la naissance
    public function index_graph_pan($annee=""){
        return $this->index_graph("PAN",$annee);
    }
    //CSR
    public function index_graph_csr($annee=""){
        return $this->index_graph("CSR",$annee);
    }
    //FSO
    public function index_graph_fso($annee=""){
        return $this->index_graph("FSO",$annee);
    }

    public function index_graph($type_aide,$annee="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $title=MyApp::TYPES_AIDES[$type_aide];
        $this->menu=strtolower('analyses_'.$type_aide);
        $this->submenu=strtolower('graph_'.$type_aide);

        $statistiques=new Collection();
        $versements=Versement::where('type','=',$type_aide)->orderBy('date','ASC')->get();
        if(!$annee) $versements=Versement::where('type','=',$type_aide)->orderBy('date','ASC')->get();
        else $versements=Versement::where('date','like',$annee.'%')->where('type','=',$type_aide)->orderBy('date','ASC')->get();
       
        $nb_versements_total=$versements->count();

        //Villages
        $t_data=[];$t_label=[];
        $t_villages=Village::orderby('nom','asc')->get();
        foreach($t_villages as $village) $t_data_villages[$village->id]=0;
        //$t_data_villages[999]=0;//Autres
        foreach($versements as $versement)
        {
            $allocataire=Allocataire::find($versement->id_allocataire);
            $t_data_villages[$allocataire->id_village]++;
        }
        foreach($t_villages as $village) {
            if($t_data_villages[$village->id]) {
                $t_data[]=$t_data_villages[$village->id];
                $t_label[]=$village->nom;
            }
        }

        //Districts
        $t_data_d=[];$t_label_d=[];
        $t_districts=District::orderby('nom','asc')->get();
        foreach($t_districts as $district) $t_data_districts[$district->id]=0;
        foreach($versements as $versement)
        {
            $allocataire=Allocataire::find($versement->id_allocataire);
            $village=Village::find($allocataire->id_village);
            if($village) $id_district=$village->id_district;
            $t_data_districts[$id_district]++;
        }
        foreach($t_districts as $district) {
            if($t_data_districts[$district->id]) {
                $t_data_d[]=$t_data_districts[$district->id];
                $t_label_d[]=$district->nom;
            }
        }

        $legende_data="Allocations par Village";
        $legende_data_d="Allocations par District";
        $annees=MyApp::getAnneesPop();
        return View::make('stats.index_graph', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type_aide' => $type_aide,
            'statistiques' => $statistiques,
            'annees' => $annees,'annee' => $annee,
            'legende_data' => $legende_data,'legende_data_d' => $legende_data_d,
            't_data' => $t_data,'t_label' => $t_label,
            't_data_d' => $t_data_d,'t_label_d' => $t_label_d,

        ]);
    }

    //Spécial Aide à l'enfant
    public function index_spec_aae($mois_aff,$onglet){
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $type_aide="AAE";
        $title=MyApp::TYPES_AIDES[$type_aide];
        $this->menu=strtolower('analyses_'.$type_aide);
        $this->submenu=strtolower('tdb_'.$type_aide);
        
        //Mois premier versement
        $mois_dep=MyApp::getMoisPremierVersement($type_aide);
        $mois_fin=date('Y-m');
        
        $t_all_mois=MyApp::getListeMois($mois_dep,$mois_fin);
        if($mois_aff=="") $mois_aff=$t_all_mois[0];

        //Tranches age
        $liste_ages_enfants=MyApp::AGE_ENFANT_TRANCHES;
        $liste_ages_allocataires=MyApp::AGE_ALLOCATAIRES_TRANCHES;
        
        //chargement de la table versements_enfants
        $versements=Versement::where('type','=',$type_aide)->orderBy('date','DESC')->get();
        /*AVant table versements enfants
        $nb=VersementEnfant::count();
        if($nb==0) {
        foreach($versements as $versement) {
            $versements_enfants=VersementEnfant::where('id_versement','=',$versement->id)->delete();
            $allocataire=Allocataire::find($versement->id_allocataire);
            $enfants=$allocataire->getEnfantsAAE();
            foreach($enfants as $enfant) {
                $versements_enfants=new VersementEnfant;
                $versements_enfants->id_versement=$versement->id;
                $versements_enfants->id_enfant=$enfant->id;
                $versements_enfants->age_enfant=$enfant->Age;
                $versements_enfants->certificat=$enfant->certificat_enfant;
                $versements_enfants->save();
                }
            }
        }
        */
        

        //Districts
        $liste_iles=MyApp::ILES;
        $t_data=[];$t_label=[];
        $liste_districts=District::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        $liste_districts['A']="Autre";
        $liste_certificats=MyApp::getZBase("CERT_ENFANTS");
        foreach($liste_iles as $key=>$ile) $t_id_ile[$key]=0;
        foreach($liste_districts as $id=>$district) $t_id_district[$id]=0;
        foreach($liste_certificats as $code=>$libelle) $t_id_certificats[$code]=0;
        foreach($liste_ages_enfants as $code=>$libelle) $t_id_certificats[$code]=0;

        //Charge les données
        $statistiques=new Collection();$kk=0;
        foreach($t_all_mois as $mois) {
            $versements=Versement::where('type','=',$type_aide)->where('date','like',$mois.'%')->get();    
            $nb_enfants_mois=0;$nb_mono_parents_mois=0;$t_certificats=[];$t_nb_ile=[];$t_nb_district=[];$t_ages_enfants=[];$t_ages_allocataire=[];
            $statistique=new Collection();
            $statistique->nb_allocataires=0;
            $statistique->nb_enfants=0;
            $statistique->nb_mono_parents=0;
            $statistique->moyenne_age=0;
            $statistique->montant=0;
            foreach($versements as $versement) {
                $statistique->nb_allocataires++;
                $statistique->nb_mono_parents+=($versement->IsMonoparent)?1:0;;
                $statistique->montant+=$versement->montant+$versement->montant_r;
                $versements_enfants=VersementEnfant::where('id_versement','=',$versement->id)->get();
                foreach($versements_enfants as $versement_enfant) {
                    $nb_enfants_mois++;
                    $statistique->moyenne_age+=$versement_enfant->age_enfant;
                    if(!isset($t_certificats[$versement_enfant->certificat])) $t_certificats[$versement_enfant->certificat]=0;
                    $t_id_certificats[$versement_enfant->certificat]++;
                    $t_certificats[$versement_enfant->certificat]++;
                    $tranche_age=$versement_enfant->TrancheAge;
                    if(!isset($t_ages_enfants[$tranche_age])) $t_ages_enfants[$tranche_age]=0;
                    $t_ages_enfants[$tranche_age]++;
                }
                if(!isset($t_nb_ile[$versement->ile])) $t_nb_ile[$versement->ile]=0;
                $t_id_ile[$versement->ile]++;
                $t_nb_ile[$versement->ile]++;
                $id_district=array_search($versement->district, $liste_districts);
                if($id_district==0) $id_district="A"; //autres
                if(!isset($t_nb_district[$id_district])) $t_nb_district[$id_district]=0;
                $t_id_district[$id_district]++;
                $t_nb_district[$id_district]++;
                $tranche_age_alloc=$versement->TrancheAge;
                if(!isset($t_ages_allocataire[$tranche_age_alloc])) $t_ages_allocataire[$tranche_age_alloc]=0;
                $t_ages_allocataire[$tranche_age_alloc]++;
                
            }
            $statistique->mois=$mois;
            $statistique->nb_enfants=$nb_enfants_mois;
            $statistique->moyenne_age=($nb_enfants_mois>0)?round($statistique->moyenne_age/$nb_enfants_mois,2):"";
            $statistique->certificats=$t_certificats;
            $statistique->iles=$t_nb_ile;
            $statistique->districts=$t_nb_district;
            $statistique->ages_enfants=$t_ages_enfants;
            $statistique->ages_allocataires=$t_ages_allocataire;
            $statistiques->push($statistique);
        }

        //Liste avec unuiqmeent > 0
        $t_certificats=[];
        foreach($liste_certificats as $code=>$libelle) if($t_id_certificats[$code]>0) $t_certificats[$code]=$libelle;
        $t_iles=[];
        foreach($liste_iles as $code=>$libelle) if($t_id_ile[$code]>0) $t_iles[$code]=$libelle;
        $t_districts=[];
        foreach($liste_districts as $code=>$libelle) if($t_id_district[$code]>0) $t_districts[$code]=$libelle;
        
        //Liste ages enfants
        $t_ages_enfant=[];
        foreach($liste_ages_enfants as $code=>$libelle) $t_ages_enfant[$code]=$libelle;
        //Liste ages allocataires
        $t_ages_alloctaire=[];
        foreach($liste_ages_allocataires as $code=>$libelle) $t_ages_alloctaire[$code]=$libelle;

        //Data et Label Iles
        $t_label_ile=[];$t_data_ile=[];
        $t_label_district=[];$t_data_district=[];
        foreach($statistiques as $statistique) {
            if($mois_aff==$statistique->mois) {
                //POur Graph Iles
                foreach($t_iles as $code=>$libelle) {
                    $t_data_ile[]=isset($statistique->iles[$code])?$statistique->iles[$code]:0;
                    $t_label_ile[]=$libelle;
                }
                //POur Graph District
                foreach($t_districts as $code=>$libelle) {
                    $t_data_district[]=isset($statistique->districts[$code])?$statistique->districts[$code]:0;;
                    $t_label_district[]=$libelle;
                }
            }
        }

        //Data Ages
        $t_label_age_enfant=[];$t_label_age_allocataire=[];$t_label_certificat_enfant=[];
        $t_data_age_enfant=[];$t_data_age_allocataire=[]; $t_data_certificat_enfant=[];
        foreach($statistiques as $statistique) {
            if($mois_aff==$statistique->mois) {
                //POur Certif Enfant 
                foreach($liste_certificats as $code=>$libelle) {
                    if(isset($statistique->certificats[$code])) {
                        $t_data_certificat_enfant[]=$statistique->certificats[$code];
                        $t_label_certificat_enfant[]=$libelle;
                    }
                }
                //POur Graph Age Enfant
                foreach($liste_ages_enfants as $key=>$tranche) {
                    $t_data_age_enfant[]=$statistique->ages_enfants[$key];
                    $t_label_age_enfant[]=$tranche;
                }
                //POur Age Alloc
                foreach($liste_ages_allocataires as $key=>$tranche) {
                    $t_data_age_allocataire[]=$statistique->ages_allocataires[$key];
                    $t_label_age_allocataire[]=$tranche;
                }
            }
        }

        //Data Home général
        //Montant Versé
        $t_label_gene=[];
        $label_data_1="Montant Versé";
        foreach($t_all_mois as $key=>$date) $t_label_gene[]=MyApp::MOIS_NUM[substr($date,5,2)]." ".substr($date,0,4);
        foreach($statistiques as $statistique) {
            $t_data_gene_1[]=$statistique->montant;
        }
        $legende_data_gene="Allocations par Mois";
        $legende_data_district="Allocations par District";
        $legende_data_ile="Allocations par Ile";
        $legende_age_enfant="Allocation par tranches d'ages des enfants";
        $legende_certificat_enfant="Allocation par certificat enfants";
        $legende_age_alloctaire="Allocation par tranches d'ages des allocataires";

        $t_mois=[];
        foreach($t_all_mois as $key=>$date) $t_mois[$date]=MyApp::MOIS[substr($date,5,2)-1]." ".substr($date,0,4);

        //dd($t_data_certificat_enfant);
        return View::make('stats.aae.index_aae', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'onglet' => $onglet,
            'title' => $title,'type_aide' => $type_aide,"t_mois" => $t_mois,"mois_aff" => $mois_aff,
            'statistiques' => $statistiques,'t_data_gene_1' => $t_data_gene_1,'t_label_gene' => $t_label_gene,'legende_data_gene' => $legende_data_gene,'label_data_1' => $label_data_1,
            't_iles' =>$t_iles,'t_data_ile' => $t_data_ile,'t_label_ile' => $t_label_ile,'legende_data_ile' => $legende_data_ile,
            't_districts' =>$t_districts,'t_data_district' => $t_data_district,'t_label_district' => $t_label_district,'legende_data_district' => $legende_data_district,
            't_certificats'=>$t_certificats,'t_data_certificat_enfant' => $t_data_certificat_enfant,'t_label_certificat_enfant' => $t_label_certificat_enfant,'legende_certificat_enfant' => $legende_certificat_enfant,
            'liste_ages_enfants'=>$liste_ages_enfants,'t_data_age_enfant' => $t_data_age_enfant,'t_label_age_enfant' => $t_label_age_enfant,'legende_age_enfant' => $legende_age_enfant,
            'liste_ages_allocataires'=>$liste_ages_allocataires,'t_data_age_allocataire' => $t_data_age_allocataire,'t_label_age_allocataire' => $t_label_age_allocataire,'legende_age_alloctaire' => $legende_age_alloctaire,
        ]);
    }

    //Spécial CSR
    public function index_spec_csr($mois_aff,$onglet)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $type_aide="CSR";
        $title=MyApp::TYPES_AIDES[$type_aide];
        $this->menu=strtolower('analyses_'.$type_aide);
        $this->submenu=strtolower('tdb_'.$type_aide);
        
        //Mois premier versement
        $mois_dep=MyApp::getMoisPremierVersement($type_aide);
        $mois_fin=date('Y-m');
        
        $t_all_mois=MyApp::getListeMois($mois_dep,$mois_fin);
        if($mois_aff=="") $mois_aff=$t_all_mois[0];

        //Tranches age
        $liste_ages=MyApp::CSR_AGE_TRANCHES;
        //Montants retraite
        $liste_montant_retraite=MyApp::CSR_MONTANTS_RETRAITE;
        $liste_montant_qf=MyApp::CSR_MONTANTS_QF;

        //chargement de la table versements
        $versements=Versement::where('type','=',$type_aide)->orderBy('date','DESC')->get();

        //Districts
        $liste_iles=MyApp::ILES;
        $liste_districts=District::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        foreach($liste_iles as $key=>$ile) $t_id_ile[$key]=0;
        foreach($liste_districts as $id=>$district) $t_id_district[$district]=0;
        $temp=[];
        //Charge les données
        $statistiques=new Collection();
        foreach($t_all_mois as $mois) {
            $versements=Versement::where('type','=',$type_aide)->where('date','like',$mois.'%')->get();    
            $t_nb_ile=[];$t_nb_district=[];$t_ages_allocataire=[];$t_retraite_conjoint=[];$tranche_qf=[];$t_qf=[];
            $statistique=new Collection();
            $statistique->nb_allocataires=0;
            $statistique->montant=0;
            $statistique->caisse_conjoint="";
            foreach($versements as $versement) {
                $statistique->nb_allocataires++;
                $statistique->montant+=$versement->montant+$versement->montant_r;
                if(!isset($t_nb_ile[$versement->ile])) $t_nb_ile[$versement->ile]=0;
                $t_id_ile[$versement->ile]++;
                $t_nb_ile[$versement->ile]++;
                if(!isset($t_nb_district[$versement->district])) $t_nb_district[$versement->district]=0;
                $t_id_district[$versement->district]++;
                $t_nb_district[$versement->district]++;
                $tranche_age_alloc=$versement->TrancheAgeCSR;
                if(!isset($t_ages_allocataire[$tranche_age_alloc])) $t_ages_allocataire[$tranche_age_alloc]=0;
                $t_ages_allocataire[$tranche_age_alloc]++;
                $tranche_retraite_conjoint=$versement->TrancheRetraiteConjointCSR;
                //$tranche_retraite_conjoint=$versement->CSRTrancheQF;
                if(!isset($t_retraite_conjoint[$tranche_retraite_conjoint])) $t_retraite_conjoint[$tranche_retraite_conjoint]=0;
                $t_retraite_conjoint[$tranche_retraite_conjoint]++;  
                //if($versement->id==1368) dd($t_retraite_conjoint);
                $tranche_qf=$versement->CSRTrancheQF;
                if(!isset($t_qf[$tranche_qf])) $t_qf[$tranche_qf]=0;
                $t_qf[$tranche_qf]++;  

            }
            $statistique->mois=$mois;
            $statistique->iles=$t_nb_ile;
            $statistique->districts=$t_nb_district;
            $statistique->ages_allocataires=$t_ages_allocataire;
            $statistique->conjoint_retraite=$t_retraite_conjoint;
            $statistique->qf=$t_qf;
            $statistiques->push($statistique);
            $temp[]=$t_qf;
        }


        //Liste avec unuiqmeent > 0
        $t_iles=[];
        foreach($liste_iles as $code=>$libelle) if($t_id_ile[$code]>0) $t_iles[$code]=$libelle;
        $t_districts=[];
        foreach($liste_districts as $code=>$libelle) if($t_id_district[$libelle]>0) $t_districts[$code]=$libelle;

        //Data et Label Iles
        $t_label_ile=[];$t_data_ile=[];
        $t_label_district=[];$t_data_district=[];
        foreach($statistiques as $statistique) {
            if($mois_aff==$statistique->mois) {
                //POur Graph Iles
                foreach($t_iles as $code=>$libelle) {
                    $t_data_ile[]=isset($statistique->iles[$code])?$statistique->iles[$code]:0;
                    $t_label_ile[]=$libelle;
                }
                //POur Graph District
                foreach($t_districts as $code=>$libelle) {
                    $t_data_district[]=isset($statistique->districts[$libelle])?$statistique->districts[$libelle]:"";
                    $t_label_district[]=$libelle;
                }
            }
        }

        //Data Ages
        $t_label_age_allocataire=[];$t_data_age_allocataire=[];
        $t_label_retraite_conjoint=[];$t_data_retraite_conjoint=[];
        foreach($statistiques as $statistique) {
            if($mois_aff==$statistique->mois) {
                //POur Age Alloc
                foreach($liste_ages as $key=>$tranche) {
                    $t_data_age_allocataire[]=isset($statistique->ages_allocataires[$key])?$statistique->ages_allocataires[$key]:0;
                    $t_label_age_allocataire[]=$tranche;
                }
                //POur Retrite conjoint
                foreach($liste_montant_retraite as $key=>$tranche) {
                    $t_data_retraite_conjoint[]=isset($statistique->conjoint_retraite[$key])?$statistique->conjoint_retraite[$key]:0;
                    $t_label_retraite_conjoint[]=$tranche;
                }
            }
        }

        //Data Home général
        //Montant Versé
        $t_label_gene=[];
        $label_data_1="Montant Versé";
        foreach($t_all_mois as $key=>$date) $t_label_gene[]=MyApp::MOIS_NUM[substr($date,5,2)]." ".substr($date,0,4);
        foreach($statistiques as $statistique) {$t_data_gene_1[]=$statistique->montant;}

        $legende_data_gene="Allocations par Mois";
        $legende_data_district="Allocations par District";
        $legende_data_ile="Allocations par Ile";
        $legende_age_alloctaire="Allocation par tranches d'ages des allocataires";
        $legende_retraite_conjoint="Allocation par retraite du conjoint";

        $t_mois=[];
        foreach($t_all_mois as $key=>$date) $t_mois[$date]=MyApp::MOIS[substr($date,5,2)-1]." ".substr($date,0,4);

        return View::make('stats.csr.index_csr', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'onglet' => $onglet,
            'title' => $title,'type_aide' => $type_aide,"t_mois" => $t_mois,"mois_aff" => $mois_aff,
            'statistiques' => $statistiques,'t_data_gene_1' => $t_data_gene_1,'t_label_gene' => $t_label_gene,'legende_data_gene' => $legende_data_gene,'label_data_1' => $label_data_1,
            't_iles' =>$t_iles,'t_data_ile' => $t_data_ile,'t_label_ile' => $t_label_ile,'legende_data_ile' => $legende_data_ile,
            't_districts' =>$t_districts,'t_data_district' => $t_data_district,'t_label_district' => $t_label_district,'legende_data_district' => $legende_data_district,
            'liste_montant_retraite'=>$liste_montant_retraite,'liste_montant_qf'=>$liste_montant_qf,
            't_data_retraite_conjoint' => $t_data_retraite_conjoint,'t_label_retraite_conjoint' => $t_label_retraite_conjoint,'legende_retraite_conjoint' => $legende_retraite_conjoint,
            'liste_ages'=>$liste_ages,'t_data_age_allocataire' => $t_data_age_allocataire,'t_label_age_allocataire' => $t_label_age_allocataire,'legende_age_alloctaire' => $legende_age_alloctaire,
        ]);
    }

    //Spécial FSO
    public function index_spec_fso($mois_aff,$onglet){
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $type_aide="FSO";
        $title=MyApp::TYPES_AIDES[$type_aide];
        $this->menu=strtolower('analyses_'.$type_aide);
        $this->submenu=strtolower('tdb_'.$type_aide);
        
        //Tranches age
        $liste_ages_allocataires=MyApp::AGE_ALLOCATAIRES_TRANCHES;
        $liste_cat_revenus=MyApp::CAT_REVENUS_FOYER;
        $liste_cat_revenus_HTML=MyApp::CAT_REVENUS_FOYER_HTML;
        //Mois premier versement
        $mois_dep=MyApp::getMoisPremierVersement($type_aide);
        $mois_fin=date('Y-m');
        
        $t_all_mois=MyApp::getListeMois($mois_dep,$mois_fin);
        if($mois_aff=="") $mois_aff=$t_all_mois[0];

        //chargement de la table versements_enfants
        $versements=Versement::where('type','=',$type_aide)->orderBy('date','DESC')->get();

        //Districts
        $liste_iles=MyApp::ILES;
        $t_data=[];$t_label=[];
        $liste_districts=District::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        $liste_districts['A']="Autre";
        foreach($liste_iles as $key=>$ile) $t_id_ile[$key]=0;
        foreach($liste_districts as $id=>$district) $t_id_district[$id]=0;


        //Charge les données
        $statistiques=new Collection();
        foreach($t_all_mois as $mois) {
            $versements=Versement::where('type','=',$type_aide)->where('date','like',$mois.'%')->get();    
            $nb_mono_parents_mois=0;$t_nb_ile=[];$t_nb_district=[];$t_ages_allocataire=[];$t_categ_revenu=[];
            $statistique=new Collection();
            $statistique->nb_allocataires=0;
            $statistique->nb_mono_parents=0;
            $statistique->qf=0;
            $statistique->montant=0;
            foreach($versements as $versement) {
                $statistique->nb_allocataires++;
                $statistique->nb_mono_parents+=($versement->IsMonoparent)?1:0;;
                $statistique->montant+=$versement->montant+$versement->montant_r;
                if(!isset($t_nb_ile[$versement->ile])) $t_nb_ile[$versement->ile]=0;
                $t_id_ile[$versement->ile]++;
                $t_nb_ile[$versement->ile]++;
                $id_district=array_search($versement->district, $liste_districts);
                if($id_district==0) $id_district="A"; //autres
                if(!isset($t_nb_district[$id_district])) $t_nb_district[$id_district]=0;
                $t_id_district[$id_district]++;
                $t_nb_district[$id_district]++;
                //Par Age
                $tranche_age_alloc=$versement->TrancheAge;
                if(!isset($t_ages_allocataire[$tranche_age_alloc])) $t_ages_allocataire[$tranche_age_alloc]=0;
                $t_ages_allocataire[$tranche_age_alloc]++;
                //PAr Revenus
                $statistique->qf+=$statistique->qf;
                $categ_revenu=$versement->CategorieRevenu;
                if(!isset($t_categ_revenu[$categ_revenu])) $t_categ_revenu[$categ_revenu]=0;
                $t_categ_revenu[$categ_revenu]++;
                
            }
            $statistique->mois=$mois;
            $statistique->iles=$t_nb_ile;
            $statistique->districts=$t_nb_district;
            $statistique->ages_allocataires=$t_ages_allocataire;
            $statistique->revenus=$t_categ_revenu;
            $statistiques->push($statistique);
        }


        $t_iles=[];
        foreach($liste_iles as $code=>$libelle) if($t_id_ile[$code]>0) $t_iles[$code]=$libelle;
        $t_districts=[];
        foreach($liste_districts as $code=>$libelle) if($t_id_district[$code]>0) $t_districts[$code]=$libelle;
        
        //Liste ages allocataires
        $t_ages_allocataire=[];
        foreach($liste_ages_allocataires as $code=>$libelle) $t_ages_allocataire[$code]=$libelle;


        //Data et Label Iles
        $t_label_ile=[];$t_data_ile=[];
        $t_label_district=[];$t_data_district=[];
        foreach($statistiques as $statistique) {
            if($mois_aff==$statistique->mois) {
                //POur Graph Iles
                foreach($t_iles as $code=>$libelle) {
                    $t_data_ile[]=isset($statistique->iles[$code])?$statistique->iles[$code]:0;
                    $t_label_ile[]=$libelle;
                }
                //POur Graph District
                foreach($t_districts as $code=>$libelle) {
                    $t_data_district[]=isset($statistique->districts[$code])?$statistique->districts[$code]:0;;
                    $t_label_district[]=$libelle;
                }
            }
        }

        //Data Ages
        $t_label_age_allocataire=[];
        $t_data_age_allocataire=[]; 
        foreach($statistiques as $statistique) {
            if($mois_aff==$statistique->mois) {
                //POur Age Alloc
                foreach($liste_ages_allocataires as $key=>$tranche) {
                    $t_data_age_allocataire[]=isset($statistique->ages_allocataires[$key])?$statistique->ages_allocataires[$key]:0;
                    $t_label_age_allocataire[]=$tranche;
                }
            }
        }

        //Data Revenus
        $t_label_revenus=[];
        $t_data_revenus=[]; 
        foreach($statistiques as $statistique) {
            if($mois_aff==$statistique->mois) {
                //POur Revenus 
                foreach($liste_cat_revenus as $key=>$tranche) {
                    $t_data_revenus[]=isset($statistique->revenus[$key])?$statistique->revenus[$key]:0;
                    $t_label_revenus[]=$tranche;
                }
            }
        }


        //Data Home général
        //Montant Versé
        $t_label_gene=[];
        $label_data_1="Montant Versé";
        foreach($t_all_mois as $key=>$date) $t_label_gene[]=MyApp::MOIS_NUM[substr($date,5,2)]." ".substr($date,0,4);
        foreach($statistiques as $statistique) {
            $t_data_gene_1[]=$statistique->montant;
        }
        $legende_data_gene="Filet Social par Mois";
        $legende_data_district="Filet Social par District";
        $legende_data_ile="Filet Social par Ile";
        $legende_age_alloctaire="Filet Social par tranches d'ages des allocataires";

        $t_mois=[];
        foreach($t_all_mois as $key=>$date) $t_mois[$date]=MyApp::MOIS[substr($date,5,2)-1]." ".substr($date,0,4);

        return View::make('stats.fso.index_fso', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'onglet' => $onglet,
            'title' => $title,'type_aide' => $type_aide,"t_mois" => $t_mois,"mois_aff" => $mois_aff,
            'statistiques' => $statistiques,'t_data_gene_1' => $t_data_gene_1,'t_label_gene' => $t_label_gene,'legende_data_gene' => $legende_data_gene,'label_data_1' => $label_data_1,
            't_iles' =>$t_iles,'t_data_ile' => $t_data_ile,'t_label_ile' => $t_label_ile,'legende_data_ile' => $legende_data_ile,
            't_districts' =>$t_districts,'t_data_district' => $t_data_district,'t_label_district' => $t_label_district,'legende_data_district' => $legende_data_district, 
            'liste_ages_allocataires'=>$liste_ages_allocataires,'t_data_age_allocataire' => $t_data_age_allocataire,'t_label_age_allocataire' => $t_label_age_allocataire,'legende_age_alloctaire' => $legende_age_alloctaire,
            'liste_cat_revenus' => $liste_cat_revenus,"liste_cat_revenus_HTML"=>$liste_cat_revenus_HTML,'t_data_revenus' => $t_data_revenus,'t_label_revenus' => $t_label_revenus,
        ]);
    }
}
