<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Versement;
use Illuminate\Support\Collection;
use App\Models\Allocataire;
use App\Models\AllocataireRessource;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
 
class VersementsRessourcesController extends Controller {
    private $menu_home="versements";
    private $menu='versements';
    private $submenu='ressources';

    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DIS_VISU")) return redirect('home');
        $last_vers=Versement::whereIn('type',['AAE'])->orderby('num_imp')->first();
        $date="";$versements=[];
        if($last_vers) {
            $date=$last_vers->date;
            $versements=Versement::whereIn('type',['AAE'])->where('num_imp','=',$last_vers->num_imp)->get();
        
            $vers=new Collection();
            $t_types=['RES_APA'];
            foreach($versements as $versement) {
                $allocataires_ressources_montant = AllocataireRessource::
                    where('id_allocataire','=',$versement->id_allocataire)
                    ->whereIn('type_ressource',$t_types)
                    ->where(function($query) use ($date) {
                        $query->where('date_fin', '=','')
                        ->orWhereNull('date_fin')
                        ->orWhere('date_fin','>=',$date);
                    });//->sum('montant');
                
                if($allocataires_ressources_montant->count()>0) {
                    $allocataires_ressources_montant = $allocataires_ressources_montant->sum('montant');
                    if($versement->montant<>$allocataires_ressources_montant ) {
                        $versement->montant_allocataire=$allocataires_ressources_montant;
                        $vers->push($versement);
                    }
                }
            }
        }

        return View::make('ressources.index_versements', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'vers'=>$vers
        ]);
    }
 

    public function maj_ressources() {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) return redirect('home');
        $type="CSR";
        $num_imp=5;
        $versements=Versement::where('type','=',$type)->where('num_imp','=',$num_imp)->get();
        foreach($versements as $versement) {
            $allocataire=Allocataire::find($versement->id_allocataire);
            $versement->qf=$allocataire->QF;
            //Cas conjoint non titulaire
            if(!$allocataire->IsConjoint) $id_conjoint=$allocataire->FamilleIdConjoint;
            else $id_conjoint=$allocataire->FamilleIdTitulaire;
            $versement->id_conjoint=($id_conjoint)?$id_conjoint:null;
            if($versement->id_conjoint) {
                $conjoint=Allocataire::find($versement->id_conjoint);
                if($conjoint) $versement->retraite_conjoint=$conjoint->MontantRessources;
            }
            $versement->save();
        }
    }
}