<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Village;
use App\Models\District;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\VillageRequest;
use View;
 
class VillagesController extends Controller {

    private $menu='parametres';
    private $submenu='villages';

    public function index()
    {
       if(!($user=Auth::user())) return Redirect::route( 'login' );
       if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VIL_VISU")) return redirect('home');

       $villages = Village::all();

        return View::make('param.villages.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'villages'=>$villages
        ]);
    }
 

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VIL_AJO")) return redirect('home');

        $districts=District::orderby('nom')->get()->pluck("nom", "id")->toArray();
        $mode="create";
        return View::make('param.villages.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode"=>$mode,
            "districts" => $districts
        ]);
    }


    public function store(VillageRequest $request)
    {
        $village = $this->setData($request);
        $msg="Le Village ".$village->nom." a été créé";
        Session::flash('message', $msg);
        return Redirect::to('villages');
    }
 

    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($mode=="edit") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VIL_MAJ")) return redirect('home');
        else if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VIL_VISU")) return redirect('home');

        $village = Village::find($id);

        $districts=District::orderby('nom')->get()->pluck("nom", "id")->toArray();
        return View::make('param.villages.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode"=>$mode,
            "village" => $village,"districts" => $districts
        ]);
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit($id,"show");
    }

    public function update($id,VillageRequest $request)
    {
        $village = $this->setData($request,$id);
        $msg="Le Village ".$village->nom." a été mis à jour";
        Session::flash('message', $msg);
        return Redirect::to('villages');
    }
 

    public function destroy($id)
    {
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("VIL_SUP")) return redirect('home');

        Village::destroy($id);
        return Redirect::to('villages');
    }
 
    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $village =  new Village;
        else $village = Village::find($id);
        
        $village->nom  = ($request->nom);
        $village->id_district  = $request->id_district; 
        $village->save();

        return $village;
    }



}