<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\ZBase;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\ZBaseRequest;
use View;
 
class ZBasesController extends Controller {

    private $menu_home="parametres";
    private $menu='divers';
    private $submenu='zbases';


    public function index($zbase="")
    {
       if(!($user=Auth::user())) return Redirect::route( 'login' );
       if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BAS_VISU")) return redirect('home');

        $zbases = [];
        if($zbase) $zbases = ZBase::where("nom","=",$zbase)->orderby('libelle','ASC')->get();
        $liste_bases= ZBase::select("nom")->distinct()->orderby('nom','ASC')->pluck('nom','nom')->toArray();
        return View::make('param.zbases.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'liste_bases'=>$liste_bases,'zbases'=>$zbases,'zbase'=>$zbase
        ]);
    }
 

    public function create($nom_base="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BAS_AJO")) return redirect('home');

        $mode="create";
        
        return View::make('param.zbases.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
            "nom_base" => $nom_base,
        ]);
    }
    public function create_base($nom_base)
    {
        return $this->create($nom_base);
    }

    public function store(ZBaseRequest $request)
    {
        $zbase = $this->setData($request);
        $msg="Le ZBase ".$zbase->nom." ".$zbase->libelle." a été créé";
        Session::flash('message', $msg);
        return Redirect::to('zbases_filtre/'.$zbase->nom);
    }
 

    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($mode=="edit") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BAS_MAJ")) return redirect('home');
        

        $base = ZBase::find($id);
        $nom_base=$base->nom;
        return View::make('param.zbases.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
            "base" => $base,"nom_base" => $nom_base,
        ]);
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BAS_VISU")) return redirect('home');

        return $this->edit($id,"show");
    }

    public function update($id,ZBaseRequest $request)
    {
        $zbase = $this->setData($request,$id);
        $msg="Le ZBase ".$zbase->nom." a été mis à jour";
        Session::flash('message', $msg);
        return Redirect::to('zbases_filtre/'.$zbase->nom);
    }
 

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BAS_SUP")) return redirect('home');

        ZBase::destroy($id);
        return Redirect::to('zbases');
    }
 
    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $zbase =  new ZBase;
        else $zbase = ZBase::find($id);
        
        $zbase->nom  = strtoupper($request->nom);
        $zbase->code   = $request->code; 
        $zbase->libelle   = $request->libelle; 
        $zbase->libelle_court   = $request->libelle_court; 
        $zbase->ordre   = $request->ordre; 
        $zbase->save();

        return $zbase;
    }



}