<?php namespace App\Models;

use App\Models\Sipre\SipreBeneficiaire;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use Illuminate\Support\Facades\Auth;
use DateTime;
use \Venturecraft\Revisionable\RevisionableTrait;

class Allocataire extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'allocataires';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;
    //protected $keepRevisionOf = ['title'];
    //protected $dontKeepRevisionOf = ['category_id'];
    //protected $historyLimit = 500; //Stop tracking revisions after 500 changes have been made.

    public function enfants()
    {
        return $this->hasMany('Enfant','parents1','benjum');
    }

    public function enfants_conjoint()
    {
        return $this->hasMany('Enfant','parents2','benjum');
    }


    /* Dates */
    public function getDates()
    {
        return array('date_naissance','date_deces','date_pi','procuration_date_naissance','date_arrivee_wf','date_depart_wf',
            'procuration_date_debut','procuration_date_fin',
            'date_ouverture_aae','date_fermeture_aae',
            'date_ouverture_csr','date_fermeture_csr',
            'updated_at','created_at');
    }
    //Dates AAE
    public function getDateOuvertureAAEAttribute($value)
    {
        return ($this->attributes['date_ouverture_aae']!=null)?date('d/m/Y', strtotime($this->attributes['date_ouverture_aae'])):null;
    }
    public function getDateFermetureAAEAttribute($value)
    {
        return ($this->attributes['date_fermeture_aae']!=null)?date('d/m/Y', strtotime($this->attributes['date_fermeture_aae'])):null;
    }
    //Dates AAE US
    public function getDateOuvertureAAEUSAttribute($value)
    {
        return ($this->attributes['date_ouverture_aae']!=null)?date('Y-m-d', strtotime($this->attributes['date_ouverture_aae'])):null;
    }
    public function getDateFermetureAAEUSAttribute($value)
    {
        return ($this->attributes['date_fermeture_aae']!=null)?date('Y-m-d', strtotime($this->attributes['date_fermeture_aae'])):null;
    }
    //Dates CSR
    public function getDateOuvertureCSRAttribute($value)
    {
        return ($this->attributes['date_ouverture_csr']!=null)?date('d/m/Y', strtotime($this->attributes['date_ouverture_csr'])):null;
    }
    public function getDateFermetureCSRAttribute($value)
    {
        return ($this->attributes['date_fermeture_csr']!=null)?date('d/m/Y', strtotime($this->attributes['date_fermeture_csr'])):null;
    }
    //Dates CSR US
    public function getDateOuvertureCSRUSAttribute($value)
    {
        return ($this->attributes['date_ouverture_csr']!=null)?date('Y-m-d', strtotime($this->attributes['date_ouverture_csr'])):null;
    }
    public function getDateFermetureCSRUSAttribute($value)
    {
        return ($this->attributes['date_fermeture_csr']!=null)?date('Y-m-d', strtotime($this->attributes['date_fermeture_csr'])):null;
    }
    //Dates NAISSANCE
    public function getDateNaissanceAttribute($value)
    {
        return ($this->attributes['date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['date_naissance'])):null;
    }
    //Dates DECES
    public function getDateDecesAttribute($value)
    {
        return ($this->attributes['date_deces']!=null)?date('d/m/Y', strtotime($this->attributes['date_deces'])):null;
    }

    //Date arrivée W&F
    public function getDateArriveeWFAttribute($value)
    {
        return ($this->attributes['date_arrivee_wf']!=null)?date('d/m/Y', strtotime($this->attributes['date_arrivee_wf'])):null;
    }

    //Date départ W&F
    public function getDateDepartWFAttribute($value)
    {
        return ($this->attributes['date_depart_wf']!=null)?date('d/m/Y', strtotime($this->attributes['date_depart_wf'])):null;
    }

    public function getDatePiAttribute($value)
    {
        return (($this->attributes['date_pi']!=null))?date('d/m/Y', strtotime($this->attributes['date_pi'])):null;
    }

    public function getProcurationDateNaissanceAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateNaissanceUSAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateDebutAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateDebutUSAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateFinAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getProcurationDateFinUSAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getUpdatedAtAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['updated_at'])):null;
    }

    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }
    public function getCreatedAtDayAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/y', strtotime($this->attributes['created_at'])):null;
    }

    /***************/
    /* NOM ADRESSE */
    /***************/
    public function getIdPADAttribute()
    {
        return str_pad($this->id, 5, "0", STR_PAD_LEFT);
    }
    public function getIdCPSWFPADAttribute()
    {
        return str_pad($this->id_cpswf, 5, "0", STR_PAD_LEFT);
    }

    /* ADRESSE */
    public function getVillageFullNameAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        return $village->FullName;
    }

    public function getVillageFullName2Attribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        return $village->FullName2;
    }

    public function getVillageNomAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        return $village->nom;
    }

    public function getIleAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "A";
        return $village->ile;
    }

    public function getDistrictNomAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        $district=District::find($village->id_district);
        if(!$district) return "";
        return $district->nom;
    }

    public function getAdresseCompleteAttribute()
    {
        $sep="<br/>";
        $adresse=trim($this->adresse);
        if($this->id_village) $adresse.=$sep.$this->VillageFullName;

        return trim($adresse);
    }

    public function getAdresseComplete2($sep="\n")
    {

        $adresse=trim($this->adresse);
        if($this->id_village) {
            $village=Village::find($this->id_village);
            if($village) $adresse.=" - ".$village->getFullName3($sep);
        }
        return trim($adresse);
    }



    /***************/
    /* NOM         */
    /***************/
    /* NOM+PRENOM  */
    public function getNomCompletAttribute()
    {
        if($this->nom) $lib=$this->nom." ".$this->prenom.(($this->nom)?" - Né".(($this->sexe=="M")?" ":"e ").$this->nom_naissance:"");
        else $lib=$this->nom_naissance." ".$this->prenom;
        return $lib;
    }

    public function getNomComplet2Attribute()
    {
        if($this->nom) $lib=$this->nom." ".$this->prenom.(($this->nom)?" - Né".(($this->sexe=="M")?" ":"e ").$this->nom_naissance:"");
        else $lib=$this->nom_naissance." ".$this->prenom;
        return $lib;
    }

    /* NOM seul pour éditions */
    public function getNomReduit($taille_max=20)
    {
        $nom=trim($this->nom_naissance);
        if(strlen($nom)>$taille_max) $nom=substr($nom,0,$taille_max);
        return trim($nom);
    }

    /* NOM+PRENOM pour éditions */
    public function getNomCompletReduit($taille_max=20)
    {
        if(strlen($this->nom_naissance." ".$this->prenom)<=$taille_max) return $this->nom_naissance." ".$this->prenom;
        $t_prenom=explode(' ',$this->prenom);
        $prenom=trim($t_prenom[0]);
        $nom=trim($this->nom_naissance);
        if(strlen($nom." ".$prenom)>$taille_max) $prenom=substr($prenom,0,1).".";
        return $nom." ".$prenom;
    }

    /* NOM+PRENOM (1er lettre si > taille) pour éditions */
    public function getNomPrenomReduit($taillemax=30)
    {
        $nom=trim($this->nom_naissance);
        if(strlen($nom)>$taillemax) $nom=substr($nom,0,$taillemax);
        $t_prenom=explode(' ',trim($this->prenom));
        $prenom=trim($t_prenom[0]);
        if(strlen($nom." ".$prenom)>$taillemax) $prenom=substr($prenom,0,1).".";

        return trim($nom." ".$prenom);
    }

    /* Etat Civil */
    public function getEtatCivilAttribute()
    {
        if($this->sexe=="M") return "M";
        if($this->sexe=="F") return "Mme";  
        return "";
    }

    /* Etat Civil Long */
    public function getEtatCivilLongAttribute()
    {
        if($this->sexe=="M") return "Monsieur";
        if($this->sexe=="F") return "Madame";  
        return "";
    }

    /* Etat Civil Code */
    public function getEtatCivilCodeAttribute()
    {
        if($this->sexe=="M") return "1";
        if($this->sexe=="F") return "2";  
        return "";
    }
    
    /***************/
    /* AGE         */
    /***************/
    public function getAgeAttribute()
    {
        $date=$this->attributes['date_naissance'];
        $age= (int) ((time() - strtotime($date)) / 3600 / 24 / 365);

        return $age;
    }

    public function getAgeDate($date_day)
    {
        $date=$this->attributes['date_naissance'];
        $age= (int) ((strtotime($date_day) - strtotime($date)) / 3600 / 24 / 365);
        return $age;
    }

    public function getAgeMoisJourAttribute()
    {
        $date=date_create($this->attributes['date_naissance']);
        $today = new DateTime();
        $diff  = $today->diff($date);
        return array('y' => $diff->y, 'm' => $diff->m, 'd' => $diff->d, 'days' => $diff->days);
    }

    public function getEcartAgeConjointAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return ""; 
        $ecart=$this->age-$conjoint->age;

        return $ecart;
    }

    /***************/
    /* ABSENCE W&F         */
    /***************/
    public function getDureeAbsence()
    {
        $date_debut=$this->attributes['date_depart_wf'];
        $t=MyApp::getDateDiffToday($date_debut);
        $nb_ans=$t['a'];$nb_mois=$t['m'];$nb_jours=$t['j'];
        $res="";
        if($nb_ans>0) $res.=$nb_ans."a/";
        if($nb_mois>0) $res.=$nb_mois."m/";
        $res.=$nb_jours."j";
        return $res;
    }
    public function getDureePresence()
    {
        $date_debut=$this->attributes['date_arrivee_wf'];
        $t=MyApp::getDateDiffToday($date_debut);
        $nb_ans=$t['a'];$nb_mois=$t['m'];$nb_jours=$t['j'];
        $res="";
        if($nb_ans>0) $res.=$nb_ans."a/";
        if($nb_mois>0) $res.=$nb_mois."m/";
        $res.=$nb_jours."j";
        return $res;
    }

    public function getDureeAbsencejour()
    {
        if(!$this->attributes['date_depart_wf']) return "";
        $date_debut=$this->attributes['date_depart_wf'];
        $date_fin=date('Y-m-d');
        $nb=MyApp::getNbJours($date_debut,$date_fin);
        return $nb;
    }

    public function getDureePresencejour()
    {
        if(!$this->attributes['date_arrivee_wf']) return "";
        $date_debut=$this->attributes['date_arrivee_wf'];
        $date_fin=date('Y-m-d');
        $nb=MyApp::getNbJours($date_debut,$date_fin);
        return $nb;
    }

    /***************/
    /* Droits  */
    /***************/

    public function getHasDroitsOuverture($type_aide,$date_ref="")
    {
        $date_ouv="";
        if($type_aide=="PAN") return true; 
        if($type_aide=="FSO") return true; 
        if(!$date_ref) $date_ref=date("Y-m-d");
        if($type_aide=="AAE") {$date_ouv=$this->DateOuvertureAAEUS;$date_fer=$this->DateFermetureAAEUS;}
        if($type_aide=="CSR") {$date_ouv=$this->DateOuvertureCSRUS;$date_fer=$this->DateFermetureCSRUS;}
        
        //if($this->id==13) dd($date_ref."<".$date_ouv);
        if(!$date_ouv) return false;
        else if($date_ref<$date_ouv) return false;
        else if(($date_fer)&&($date_ref>$date_fer)) return false;
        return true;
    }

    public function getDroitsOuverture($type_aide,$date_ref="")
    {
        $date_ouv="";
        if($type_aide=="PAN") return true; 
        if($type_aide=="FSO") return true; 
        if(!$date_ref) $date_ref=date("Y-m-d");
        if($type_aide=="AAE") {$date_ouv=$this->DateOuvertureAAEUS;$date_fer=$this->DateFermetureAAEUS;}
        if($type_aide=="CSR") {$date_ouv=$this->DateOuvertureCSRUS;$date_fer=$this->DateFermetureCSRUS;}
        if($type_aide=="AGD") return true; 
        if($type_aide=="APH") return true; 
        
        //if($this->id==13) dd($date_ref."<".$date_ouv);
        if(!$date_ouv) $msg="NDF";
        else if($date_ref<$date_ouv) $msg="ATT";
        else if(($date_fer)&&($date_ref>$date_fer)) $msg="FER";
        else $msg="OUV";
        return $msg;
    }

    public function getDroitsOuvertureBadge($type_aide="",$date_ref="",$badge=false)
    {
        if(!$date_ref) $date_ref=date("Y-m-d");
        
        $msg="";
        if($type_aide=="AAE") $msg=$this->getDroitsOuverture($type_aide,$date_ref);
        if($type_aide=="CSR") $msg=$this->getDroitsOuverture($type_aide,$date_ref);
        if($msg) {
            if($badge) {
                if($msg!="OUV") $msg="<span class='badge badge-danger right'>". MyApp::DROITS_OUVERTURE[$msg]."</span>";
                else $msg="<span class='badge badge-success right'>". MyApp::DROITS_OUVERTURE[$msg]."</span>";
            } else $msg=MyApp::DROITS_OUVERTURE[$msg];
        }

        return $msg;
    }

    public function getSituationWF()
    {
        $delais_presence=MyApp::DUREE_ALERTE_PRESENCE; //90j
        $delais_absence=MyApp::DUREE_ALERTE_ABSENCE;; //90j
        $presence_jours=$this->getDureePresencejour();
        $absence_jours=$this->getDureeAbsencejour();
        if($presence_jours && $absence_jours) return "-";

        $msg="";
        if(!$absence_jours && $presence_jours) {
            //$color="default";
            //if($presence_jours<=$delais_presence) $color="danger";
            //$msg="<span class='badge badge-".$color." right'>Présence depuis ".$presence_jours."jours</span>";
            if($presence_jours>30) $absence_jours=$this->getDureePresence();
            else $presence_jours.="j";
            $msg="Présence depuis ".$presence_jours;
        }
        elseif($absence_jours) {
            //$color="default";
            //if($absence_jours>=$delais_absence) $color="danger";
            //$msg="<span class='badge badge-".$color." right'>Absence depuis ".$absence_jours."jours</span>";
            if($absence_jours>30) $absence_jours=$this->getDureeAbsence();
            else $absence_jours.="j";
            $msg="Absence depuis ".$absence_jours;
        }
        return $msg;
    }

    /***************/
    /* CONJOINT  */
    /***************/
    /* Retourne le conjoint */
    public function getConjoint()
    {
        $conjoint=Allocataire::find($this->id_conjoint);
        if(!$conjoint) return "";
        return $conjoint;
    }
    /* Retourne l'id du partanaire, conjoiunt ou titulaire */
    public function getConjointNomCompletAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->NomComplet;
    }
    /* Retourne StatutConjoint conjoiunt ou titulaire */
    public function getStatutConjointAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->statut;
    }
    /* Retourne l'id du partanaire, conjoiunt ou titulaire */
    public function getConjointNomStatutCompletAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->NomComplet." (".$conjoint->statut.")";
    }

    

    /***************/
    /* PARTENAIRE  */
    /***************/


    /* Retourne l'id du partanaire, conjoiunt ou titulaire */
    /*
    public function getIdPartenaireAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        if($this->IsTitulaire) return $famille->id_conjoint;
        return $famille->id_titulaire;
    }

    public function getIdPADPartenaireAttribute()
    {
        return str_pad($this->IdPartenaire, 5, "0", STR_PAD_LEFT);
    }

    //Retourne l'id du partanaire, conjoiunt ou titulaire 
    public function getPartenaire()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        $id_partenaire=($famille->id_conjoint!=$this->id)?$famille->id_conjoint:$famille->id_titulaire;
        $partenaire=Allocataire::find($id_partenaire);
        return $partenaire;
    }
        */

    /***************/
    /* FAMILLE      */
    /***************/
    public function getEnfantLienParenteAttribute()
    {
        $famille_enfant=FamilleEnfant::where("id_famille","=",$this->id_famille)->where("id_enfant","=",$this->id)->first();
        if(!$famille_enfant) return "";
        if(!isset(MyApp::FOYER_ROLES[$famille_enfant->lien_parente])) return "";

        return MyApp::FOYER_ROLES[$famille_enfant->lien_parente];
    }

    public function setFamille($id_famille)
    {
        $this->id_famille = $id_famille;
        $this->save();
        return $this->save();
    }

    public function getFamille()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return []; 
        return $famille;
    }

    public function getIdPADFamilleAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        return $famille->IdPAD;
    }

    /* TITULAIRE */
    public function getIsTitulaireAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return false; 
        if($famille->id_titulaire==$this->id) return true;
        return false;
    }
    public function getFamilleIdTitulaireAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        return $famille->id_titulaire;
    }

    public function getNomCompletTitulaireAttribute()
    {
        $titulaire=Allocataire::find($this->id_titulaire);
        if(!$titulaire) return "";
        return  $titulaire->NomComplet;
    }

    /* CONJOINT */
    public function getConjointFamille()
    {
        $famille=$this->getFamille();
        if(!$famille) return ""; 
        $conjoint=$famille->getConjoint();
        if(!$conjoint) return "";
        return $conjoint;
    }

    public function getIsConjointAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return false; 
        if($conjoint_famille->id==$this->id) return true;
        return false;
    }


    public function getFamilleIdConjointAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return "";
        return  $conjoint_famille->id;
    }


    /*
    public function getFamilleConjointAttribute()
    {
        $famille=$this->getFamille();
        if(!$famille) return ""; 
        if($famille->id_conjoint==$this->id) return $famille->id_titulaire;
        $conjoint=$famille->getConjoint();
        if(!$conjoint) return "";
        return $conjoint;
    }
        */

    public function getRetraiteConjointAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return ""; 

        //Types ressources pour calcul retraite
        $types=["RES_RET"];
        return $conjoint_famille->getMontantRessourcesSpec($types);
        //return $conjoint_famille->montant_retraite;
    }

    public function getMontantRessourcesConjointAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return ""; 

        return $conjoint_famille->MontantRessources;
    }

    public function getFamilleConjointNomCompletAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return "";
        return  $conjoint_famille->NomComplet;
    }

    public function getStatutParentAttribute()
    {
        if($this->sexe=="M") return "Père";
        if($this->sexe=="F") return "Mère";
        return "";
    }

    /***************/
    /* Parents     */
    /***************/
    public function getNomCompletParent1Attribute()
    {
        $parent=Allocataire::find($this->id_parent1);
        if(!$parent) return "";
        return  $parent->NomComplet;
    }
    public function getNomCompletParent2Attribute()
    {
        $parent=Allocataire::find($this->id_parent2);
        if(!$parent) return "";
        return  $parent->NomComplet;
    }


   /***************/
    /* Dossier     */
    /***************/
    public function getStatutDossierLibelleAttribute()
    {
      $lib=MyApp::getZBaseLibelle("BEN_STATUT_DOSSIER",$this->statut_dossier,'');

      return $lib;
    }
    public function getStatutDossierLibelleCourtAttribute()
    {
      $lib=MyApp::getZBaseLibelle($nom,$this->statut_dossier,'court');
      return $lib;
    }

    public function getInfoAides($sep="<br/>")
    {
      $lib="";
      //Aide à l'enfant
      $lib.=(($lib!="")?$sep:"").$this->getInfoDetailAides();
      $lib.=(($lib!="")?$sep:"")."Date Naissance : <b>".$this->DateNaissance.(($this->certificat==9)?"-":" - ".$this->Age." ans")."</b>";
      if($this->sexe) $lib.=$sep."Sexe : <b>".MyApp::SEXE[$this->sexe]."</b>";
      if($this->id_CPSWF) $lib.=$sep."CPSWF : <b>".$this->id_CPSWF."</b>";
      if($this->certificat_enfant) $lib.=$sep."Cert.: <b>".$this->CertificatEnfantLibelle."</b>";
      if($this->id_CPSWF) $lib.=$sep."Statut : <b>".$this->id_CPSWF."</b>";
      if($this->EnfantLienParente)  $lib.=$sep."Lien de parenté : <b>".$this->EnfantLienParente."</b>";
      

      return $lib;
    }

    public function getInfoDetailAides($card=true,$sep="<br/>")
    {
        //Aide à l'enfant
        $t_aides=explode(",",$this->types_aides);
        $txt="";
        foreach($t_aides as $aide) {
            $lib=""; 
            if(array_key_exists($aide,MyApp::TYPES_AIDES)) {
                $lib=MyApp::TYPES_AIDES[$aide];
                if(!$card)  $txt.=($txt?",":"").$lib;
                else $txt.="<span class='right badge badge-".MyApp::COLOR_AIDES[$aide]."'>".$lib."</span>";
            }
        }
        return $txt;
    }
    
    //Retourne si vrai si l'allocataire bénéficie de l'aide
    public function hasAide($type_aide)
    {
        $pos = strpos($this->types_aides, $type_aide);
        if ($pos !== false) return true;
        return false;
    }


    /***************/
    /* RESPONSABLES   pour Enfants  */
    /***************/
    public function getIdResponsable1Attribute()
    {
        $famille_enfant=FamilleEnfant::where('id_enfant','=',$this->id)
            //->where('lien_parente','=','ENF')
            ->first();
        if(!$famille_enfant) return "";
        $famille=Famille::find($famille_enfant->id_famille);
        $titulaire=$famille->getTitulaire();
        // A FINIR //
        return  $titulaire->id;
    }

    public function getFamilleResponsable()
    {
        $famille_enfant=FamilleEnfant::where('id_enfant','=',$this->id)
            //->where('lien_parente','=','ENF')
            ->first();
        if(!$famille_enfant) return "";
        $famille=Famille::find($famille_enfant->id_famille);
        if(!$famille) return "";
        return  $famille;
    }

    public function getIdPADFamilleResponsableAttribute()
    {
        $famille=$this->getFamilleResponsable();
        if(!$famille) return "";
        return  $famille->IdPAD;
    }

    public function getNomCompletResponsable1Attribute()
    {
        $famille_enfant=FamilleEnfant::where('id_enfant','=',$this->id)
            //->where('lien_parente','=','ENF')
            ->first();
            
        if(!$famille_enfant) return "";
        $famille=Famille::find($famille_enfant->id_famille);
        $titulaire=$famille->getTitulaire();
        // A FINIR //
        return  $titulaire->NomComplet;
    }
    public function getNomCompletResponsable2Attribute()
    {
        $parent=Allocataire::find($this->id_parent2);
        if(!$parent) return "";
        return  $parent->NomComplet;
    }

    /***************/
    /* ENFANTS     */
    /***************/
    // Enfants de la famille sur Age 
    public function getEnfantsFamilleLESS($age=21)
    {
		$famille=Famille::find($this->id_famille);
        if(!$famille) return "";
        return $famille->getEnfantsLESS($age);
    }

    //Renvoi la famille du Enfant/allocataire
    public function getFamilleEnfant()
    {
        $famille_enfant=FamilleEnfant::where('id_enfant',"=",$this->id)->first();
        if(!$famille_enfant) return "";
        $famille=Famille::find($famille_enfant->id_famille);
        if(!$famille)  return [];
        return $famille;
    }

    //Renvoi l'identifiant de la famille du membre/allocataire
    public function getIdFamilleEnfantAttribute()
    {
        $famille=$this->getFamilleEnfant();
        if(!$famille)  return [];
        
        return str_pad($famille->id, 5, "0", STR_PAD_LEFT);
    }

    public function getEnfants()
    {
        $enfants=Allocataire::where('id_parent1',"=",$this->id)->orWhere('id_parent2',"=",$this->id)->get();
        return $enfants;
    }

    public function getEnfantsFamille()
    {
        $t_id_enfants=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id_famille )
            ->pluck("familles_enfants.id_enfant")->toArray();
        $enfants=Allocataire::whereIn('id',$t_id_enfants)->get();
        return $enfants;
    }

    public function getNbEnfantsAttribute()
    {
        $nb=DB::table('familles_enfants')->where('id_famille', '=', $this->id_famille)->count();
        return $nb;
    }

    public function getNbEnfants($date)
    {
      $nb=DB::table('allocataires')->where("date_naissance","<",$date)->where("id_parent1","=",$this->id)->count();
      $nb+=DB::table('allocataires')->where("date_naissance","<",$date)->where("id_parent2","=",$this->id)->count();
      return $nb;
    }

    public function getNbEnfantsLESS($age=21)
    {
		$famille=Famille::find($this->id_famille);
        if(!$famille) return 0;
        return $famille->NbEnfantsLESS;
    }

    public function getCertificatEnfantLibelleAttribute()
    {
        $liste_certificats=MyApp::getZBase("CERT_ENFANTS");

        if(!isset($liste_certificats[$this->certificat_enfant])) return "";
        return$liste_certificats[$this->certificat_enfant];
    }
    
    public function getNewCertificatAttribute()
    {
        $date=$this->attributes['date_naissance'];
        $age=$this->Age;
        $certif=$this->certificat_enfant ;
        if($certif=='') $certif=0;
        $res=$certif;
        if(($certif==1)||($certif==2)||($certif==3)) {
            $res=8;
        }
        if(($certif==4)) $res=8;

            /*
        if($certif==0) {
            if($age<6) $res=1;
            if($age>21) $res=9;
        }
        if($certif==1) {
            $res=0;
            if($age<6) $res=1;
            if($age>21) $res=9;
        }
        if($certif==2) {
            $res=0;
            if($age<6) $res=1;
            if($age>21) $res=9;
        }
        if($certif==4) {
            $res=4;
            if($age>21) $res=9;
        }
        if($certif==3) {
            if($age<6) $res=1;
            if($age>21) $res=9;
        }
        if($certif==9) {
            //$res=9;
        }
        */

        return $res;
    }

    /***************/
    /* MEMBRES    */
    /***************/
    public function getMembres()
    {
        if(!$this->id_famille) return [];
        $famille=Famille::find($this->id_famille);
        if(!$famille)  return [];
        $membres=FamilleMembre::where('id_famille',"=",$this->id_famille)->get();
        return $membres;
    }

    //Renvoi la famille du membre/allocataire
    public function getFamilleMembre()
    {
        $famille_membre=FamilleMembre::where('id_membre',"=",$this->id)->first();
        if(!$famille_membre) return "";
        $famille=Famille::find($famille_membre->id_famille);
        if(!$famille)  return [];
        return $famille;
    }

    //Renvoi l'identifiant de la famille du membre/allocataire
    public function getIdFamilleMembreAttribute()
    {
        $famille=$this->getFamilleMembre();
        if(!$famille)  return [];
        
        return str_pad($famille->id, 5, "0", STR_PAD_LEFT);
    }

    public function getInfoLien($all=false,$sep="<br/>")
    {
        $msg="";;
        //Verifs liens
        //Comptes
        $nb  = DB::table('allocataires_comptes')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Des comptes bancaires sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

        //Ressources
        $nb  = DB::table('allocataires_ressources')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Des ressources sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

        //Famille
        $nb  = DB::table('familles')->where('id_titulaire', '=', $this->id)->count();
        $nb  += DB::table('familles')->where('id_conjoint', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Cet allocataire est encore associé à une Famille.";
        if(!$all && $msg) return $msg;

        //Aidant
        $nb  = DB::table('familles_aidants')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Cet allocataire est encore aidant dans une Famille.";
        if(!$all && $msg) return $msg;

        //Enfant
        $nb  = DB::table('familles_enfants')->where('id_enfant', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Cet allocataire est encore Enfant dans une Famille.";
        if(!$all && $msg) return $msg;

        //MEmbre
        $nb  = DB::table('familles_membres')->where('id_membre', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Cet allocataire est encore membre dans une Famille.";
        if(!$all && $msg) return $msg;

        //Versements
        $nb  = DB::table('versements')->where('id_allocataire', '=', $this->id)->count();
        $nb  += DB::table('versements')->where('id_conjoint', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Cet allocataire est associé à un versement.";
        if(!$all && $msg) return $msg;

        //Versements Enfant
        $nb  = DB::table('versements_enfants')->where('id_enfant', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Cet allocataire est associé comme enfant dans un versement.";
        if(!$all && $msg) return $msg;

        //Versement Prepa
        $nb  = DB::table('versements_prepa')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=((!$msg)?"":$sep)."Cet allocataire est associé dans un versement en préparation.";

        return $msg;
    }

    /**
     * Fiche Supprimable ?
     */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("ALO_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;

        //$msg=$this->getInfoLien();
        //if($msg) return false;
        
        return true;
    }

    /***************/
    /* AAE     */
    /***************/
    public function  getPrimeAAEAttribute()
    {
        //Prime Exceptionnelle
        $montant_prime=MyApp::getPrimeExcept();
        $prime= $montant_prime*$this->NbEnfantsAAE;
        return $prime;
    }
    /**
     * Nombre d'enfants pour Aide Sociale
     */
    public function getNbEnfantsAAEAttribute()
    {
        if(!$this->IsTitulaire) return 0;
        $certif_aae=MyApp::getCertificatsAAE();
        $nb=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id_famille )
            ->whereIn('certificat_enfant',$certif_aae)
            ->count();

            //if($this->id==563) dd($nb);
        return $nb;
    }

    /**
     * enfants avec AAE
     */
    public function  getEnfantsAAE()
    {
        if(!$this->IsTitulaire) return [];
        $certif_aae=MyApp::getCertificatsAAE();
        $t_id_enfants=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id_famille )
            ->whereIn('certificat_enfant',$certif_aae)
            ->pluck("familles_enfants.id_enfant")->toArray();
        $enfants=Allocataire::whereIn('id',$t_id_enfants)->get();
        
        
        /*$t_id_enfants=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id_famille )
            ->whereIn('certificat_enfant',$certif_aae)
            ->pluck("familles_enfants.id_enfant")->toArray();

        
        $t_id_enfants=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$id_famille )
            ->whereIn('certificat_enfant',$certif_aae)
            ->pluck("familles_enfants.id_enfant")->toArray();
        */

        
        return $enfants;
    }

    /**
     * Calcul AAE
     */
    public function  getCalculAAEAttribute()
    {
        $montant=MyApp::getMontantAAE($this->NbEnfantsAAE);
        return $montant;
    }
    
    /**
     * enfants de la famille
     */
    public function  getEnfantsListe($sep="<br/>",$age=21,$titulaire=true)
    {
        if($titulaire && !$this->IsTitulaire) return ""; // SI pas titulaire pas d'enfant associé
        $enfants=$this->getEnfantsFamilleLESS($age);
        if(!$enfants) return "";   
        $txt="";
		foreach($enfants as $enfant) {
            $certif=$enfant->Certificat;
            if(in_array($certif,MyApp::getCertificatsAAE()))  $certif="<span class='right badge badge-".MyApp::COLOR_AIDES["AAE"]."'>".$certif."</span>";
            else $certif="<span class='right badge badge-secondary'>".$certif."</span>";
			$txt.=(($txt)?$sep:"").$enfant->NomComplet."&nbsp;".$enfant->Age."a".($certif?"&nbsp;".$certif:")");
		}
        return $txt;
    }

    public function  getEnfantsPANListe($sep="<br/>")
    {
		$enfants=$this->getEnfantsEligiblePAN();
        $txt="";
		foreach($enfants as $enfant) {
            $t_age=$enfant->AgeMoisJour;
            if($t_age['m']<2) $t_id[]=$enfant->id;
			$txt.=(($txt)?$sep:"").$enfant->NomComplet."&nbsp;".$enfant->DateNaissance." (".$t_age['d']." jours)";
		}
        return $txt;
    }

    /***************/
    /* FILET SOCIAL    */
    /***************/
    // type_res=D pour détail du calcul
    public function  getCalculMontantFSOAttribute()
    {
        $famille=$this->getFamille();
        //$famille=$this->getFamille();
        //if($famille) {
        //    $montant=$famille->getCalculMontantFSO();
        //} else {
            $montant=$this->CalculFSO;
        //}
        return $montant;
    }

    public function getRaisonLibelleAttribute()
    {
      $lib=MyApp::getZBaseLibelle("BEN_RAISONS_FSO",$this->raison_fso,'');

      return $lib;
    }

    //Renvoi le montant si Elligible FSO
    public function getCalculFSOAttribute()
    {
        
        if($this->raison_fso) {
            if($this->raison_fso=="QF") return 0;
        }
        $plafond_qf=MyApp::getParam("FSO_PLAFOND");
        if($this->qf>=$plafond_qf) return 0;
        $age_min=MyApp::FSO_AGE_MIN;
        $age_tranche=MyApp::FSO_AGE_TRANCHE;
        $age_max_certif=MyApp::AGE_MAX_CERTIF;
        if($this->age<$age_min) return 0;
        $certif=$this->certificat_enfant;
        if($this->age>$age_max_certif) $certif="";
        if($certif) { //SI avec certificat
            $certifs_aurorisés=[5,6];
            $trouve=false;
            foreach($certifs_aurorisés as $key=>$certif) {
                if($certif==$this->certificat_enfant) $trouve=true;
            }
            if(!$trouve) return 0;
        }
        $montant_base_moins=MyApp::getParam("FSO_MONTANT1");
        $montant_base_plus=MyApp::getParam("FSO_MONTANT2");
        if($this->age<$age_tranche) return $montant_base_moins;
        return $montant_base_plus;
    }


    /* ******************** */
    /* Prime à la naissance  
    /* ******************** */
    public function getEligiblePANAttribute()
    {
        //Recherche les enfants de moins de 2 mois
        $enfants=$this->getEnfantsFamille();
        foreach($enfants as $enfant) {
            if(($enfant->age<1 || $enfant->force_pan)&&(!$enfant->id_versement_pan)) { //Versement pas encore fait
                $t_age=$enfant->AgeMoisJour;
                if($t_age['m']<2 || $enfant->force_pan) return true;
                //ou if($t_age['d']<=30) return true;
            }
        }
        return false;
    }

    public function getEnfantsEligiblePAN()
    {
        //Recherche les enfants de moins de 2 mois
        $t_id=[];
        $enfants=$this->getEnfantsFamille();
        foreach($enfants as $enfant) {
            if(($enfant->age<1 || $enfant->force_pan)&&(!$enfant->id_versement_pan)) { //Versement pas encore fait
                $t_age=$enfant->AgeMoisJour;
                if($t_age['m']<2 || $enfant->force_pan) $t_id[]=$enfant->id;
                //ou if($t_age['d']<=30) return true;
            }
        }
        $enfants_pan=Allocataire::whereIn("id",$t_id)->get();
        return $enfants_pan;
    }

    public function getNbEnfantsEligiblePANAttribute()
    {
        //Recherche les enfants de moins de 2 mois
        $enfants_pan=$this->getEnfantsEligiblePAN();
        if(!$enfants_pan) return 0;
        return $enfants_pan->count();
    }

    /* Listes des Id enfants PAN */
    public function  getIdEnfantsEligiblePAN()
    {
        $txt="";
        $enfants_pan=$this->getEnfantsEligiblePAN();
        foreach($enfants_pan as $enfant) $txt=((!$txt)?'':',').$enfant->id;

        return $txt;
    }

    public function  getCalculPANAttribute()
    {
        $enfants_pan=$this->getEnfantsEligiblePAN();
        $nb=$enfants_pan->count();
        if($nb==0) return 0;
        $montant_base=MyApp::getParam("PAN_PRIME");

        return $montant_base*$nb;
    }
    


    /* ******************** */
    /* CPSWF             */
    /* ******************** */
    
    public function getSipreBeneficiaire()
    {
        if(!$this->id_cpswf) return "";
        $beneficiaire=SipreBeneficiaire::find($this->id_cpswf);
        if(!$beneficiaire) return "";
        return $beneficiaire;
    }
    /* RETRAITE             */
    public function getMontantRetraiteCPSWFAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        if(!$beneficiaire) return "";
        return $beneficiaire->RetraiteMontant;
    }

    //Montant retraire
    public function getUpdatedAtCPSWFAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        if(!$beneficiaire) return "";
        return $beneficiaire->UpdatedAt;
    }

    /* Allcoations             */
    public function getMontantAllocationsAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        if(!$beneficiaire) return "";
        return $beneficiaire->AllocationsMontant;
    }
    
    /* ******************** */
    /* VERSEMENTS  
    /* ******************** */
    public function getLastVersement($type_aide)
    {
        $versement=Versement::where("id_allocataire","=",$this->id)
        ->where("type","=",$type_aide)
        ->orderby("date","DESC")->first();
        if(!$versement) return false;
        return $versement;
    }

    /***************/
    /* RESSOURCES */
    /***************/
    public function getMontantRessourcesAttribute()
    {
        $date=date('Y-m-d');
        if($this->statut=="DCD") return 0;
        $ressources=AllocataireRessource::where("id_allocataire","=",$this->id)->where("date_fin",">",$date)->sum("montant");
        $ressources+=AllocataireRessource::where("id_allocataire","=",$this->id)->whereNull("date_fin")->sum("montant");

        return $ressources;
    }

    public function getMontantRessourcesSpec($liste=[])
    {
        $date=date('Y-m-d');
        if($this->statut=="DCD") return 0;

        $montant=0;
        if($this->id==2055) dd("dd");
        $ressources=AllocataireRessource::
            where("id_allocataire","=",$this->id)->where("date_fin",">",$date)
            //->whereIn("type_ressource",$liste)
            ->get();

        foreach($ressources as $ressource) {
            dd($ressource);
            if($ressource->date_fin) $montant+=$ressource->montant;
        }
        
        return $montant;
    }

    public function getQFAttribute()
    {
        $famille=$this->getFamille();
        if(!$famille) {
            return $this->MontantRessources;
        }
        return $famille->QF;
    }

    public function getFamilleNbPersonnesAttribute()
    {
        $famille=$this->getFamille();
        if(!$famille) return 1;
        return $famille->NbPersonnes;
    }

    public function getFamilleMontantRessourcesAttribute()
    {
        $famille=$this->getFamille();
        if($famille) return $famille->MontantRessources;
        return $this->MontantRessources;
    }


    /***********/
    /* BANQUES */
    /***********/
    public function getCompteAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return "";
        $RIB=$allocataire_compte->IBAN_pays.' '.$allocataire_compte->IBAN_cle.' '.$allocataire_compte->IBAN_banque.' '.$allocataire_compte->IBAN_guichet.' '.
        $allocataire_compte->IBAN_compte.' '.$allocataire_compte->IBAN_clerib;

        return $RIB;
    }

    public function getBanqueIdAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return null;
        return $allocataire_compte->id_banque;
    }

    public function getNomBanqueAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        $banque=Banque::find($allocataire_compte->id_banque);
        if(!$banque) return "";
        return $banque->nom;
    }

    public function getNomTitulaireCompteAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return "";
        return $allocataire_compte->titulaire;
    }
    
    public function getLastCompte()
    {
    $allocataire_compte=AllocataireCompte::where("id_allocataire","=",$this->id)
          ->where("actif","=","1")->orderby("id","DESC")->first();
          if(!$allocataire_compte) return "";
          return $allocataire_compte;
    }
    public function getIBANcompletAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        $IBAN_pays=($allocataire_compte->IBAN_pays)?$allocataire_compte->IBAN_pays:"";
        $IBAN_cle=($allocataire_compte->IBAN_cle)?$allocataire_compte->IBAN_cle:"";

        return $IBAN_pays.$IBAN_cle.$allocataire_compte->RIBcomplet;
    }

    public function getRIBcompletAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        $IBAN_banque=($allocataire_compte->IBAN_banque)?$allocataire_compte->IBAN_banque:"";
        $IBAN_guichet=($allocataire_compte->IBAN_guichet)?$allocataire_compte->IBAN_guichet:"";
        $IBAN_compte=($allocataire_compte->IBAN_compte)?$allocataire_compte->IBAN_compte:"";
        $IBAN_clerib=($allocataire_compte->IBAN_clerib)?$allocataire_compte->IBAN_clerib:"";
        return $IBAN_banque.$IBAN_guichet.$IBAN_compte.$IBAN_clerib;
    }

    public function getIBAN_paysAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        return $IBAN_pays;
    }


    /* ******************** */
    /* LOG                  */
    /* ******************** */
    public function log_transaction($url,$operation,$values="") {
        $log=new Logs;
        if($values=="") {
          $t_values=$this->getAttributes();
          foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value;
        }
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
      }
  }
