<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use \Venturecraft\Revisionable\RevisionableTrait;

class AllocataireCompte extends Model {


	protected $table = 'allocataires_comptes';
  use RevisionableTrait;
  protected $revisionForceDeleteEnabled = true;
  protected $revisionCreationsEnabled = true;

    /* ******************** */
    /* LOG                  */
    /* ******************** */
    public function log_transaction($url,$operation,$values="") {
        $log=new Logs;
        if($values=="") {
          $t_values=$this->getAttributes();
          foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value;
        }
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }


    public function getUserNameAttribute()
    {
        $user=User::find($this->id_user);
        if(!$user) return "";
        return $user->name;
    }

    public function getBanqueNomAttribute()
    {
        $banque=Banque::find($this->id_banque);
        if(!$banque) return "";
        return $banque->nom;
    }

    public function getCompteAttribute()
    {
        $RIB=$this->IBAN_pays.' '.$this->IBAN_cle.' '.$this->IBAN_banque.' '.$this->IBAN_guichet.' '.
        $this->IBAN_compte.' '.$this->IBAN_clerib;

        return $RIB;
    }


}

