<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use Illuminate\Support\Facades\Auth;
use \Venturecraft\Revisionable\RevisionableTrait;

class Banque extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'banques';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    public function getNbAllocatairesAttribute()
    {
        $nb  = DB::table('allocataires_comptes')->where('id_banque', '=', $this->id)->count();
        return $nb;
    }

    public function getNbVersementsAttribute()
    {
        $nb  = DB::table('versements')->where('id_banque', '=', $this->id)->count();
        return $nb;
    }

    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }


    /* Fiche Supprimable ? */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("BQE_SUP") && !$user->HasRole("ADMINISTRATEUR")) return true;

        if($this->NbAllocataires>0) return false;
        if($this->NbVersements>0) return false;

        return true;
    }

}
