<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use \Venturecraft\Revisionable\RevisionableTrait;

class District extends Model
{

	protected $table = 'districts';
	public  $timestamps = false;
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    /**
    * Fiche Supprimable ?
    */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("DIS_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;
        $nb=$this->NbVehicules;
        if($nb>0) return false;

        return true;
    }

}