<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;
use Illuminate\Support\Facades\Auth;
use \Venturecraft\Revisionable\RevisionableTrait;

class FamilleEnfant extends Model {


	protected $table = 'familles_enfants';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    /***************/
    /* NOM ADRESSE */
    /***************/
    public function getIdAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->id;
    }

    public function getNomAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->nom;
    }

    public function getIdPADAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->IdPAD;
    }
	
    public function getNomCompletAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->NomComplet;
    }

    public function getPrenomAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->prenom;
    }

	public function getDateNaissanceAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->DateNaissance;
    }

    public function getAgeAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->Age;
    }

    public function getSexeAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->sexe;
    }

    public function getCertificatAttribute()
    {
		$enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return ""; 
        return $enfant->certificat_enfant;
    }

    
    public function getInfoAides($sep="</br>")
    {
        $enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return "";
        return $enfant->getInfoAides();
    }

    public function getInfoDetailAides($card=true,$sep="<br/>")
    {
        $enfant=Allocataire::find($this->id_enfant);
        if(!$enfant) return "";
        return $enfant->getInfoDetailAides($card,$sep);
    }
}
