<?php namespace App\Models;

use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Config;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Controllers\Logs;

class Permission2 extends Permission
{
	public function getroles()
	{
	    $liste_roles="";
		$permission_roles =  DB::table('role_has_permissions')->where('permission_id', '=', $this->id)->get();

		foreach ($permission_roles as $permission_role)
		{
			$role=Role::find($permission_role->role_id);
		    $liste_roles .=(($liste_roles=="")?"":"<br/>").($role->name);
		}
	    return $liste_roles;
	 }

	public function getGroupeNomAttribute()
	{

		$groupe =  PermissionGroupe::find($this->id_groupe);
		if(!$groupe) return "";
	    return $groupe->nom;
	 }


    /* SUPPRESSION */
    function getIsSupprimableAttribute() {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("PER_SUP")) return false;

        $permission_roles =  DB::table('role_has_permissions')->where('permission_id', '=', $this->id)->get();

        if(count($permission_roles)==0) return true;
        return false;
    }

    /* Modifiable */
    function getIsModifiableAttribute() {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("PER_MAJ")) return false;
        return true;
    }
}
