<?php namespace App\Models;

use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Config;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Controllers\Logs;
use \Venturecraft\Revisionable\RevisionableTrait;

class Role2 extends Role
{

	protected $table = 'roles';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

	public function getNomUsersAttribute()
	{
        $t_getusers=DB::table('model_has_roles')
            ->where('role_id', '=', $this->id)
            ->where('model_type','=','App\Models\User')
            ->pluck("model_id")
            ->toArray();
        $list="";
        foreach($t_getusers as $user_id) {
            $user_role=User::find($user_id);
            if($user_role) $list.=(($list=="")?"":" ; ").$user_role->name;
        }
        return $list;
    }

    public function getusers()
    {
        $t_getusers=DB::table('model_has_roles')
            ->where('role_id', '=', $this->id)
            ->where('model_type','=','App\Models\User')
            ->pluck("model_id")
            ->toArray();


        $list="";
        foreach($t_getusers as $user_id) {
            $user_role=User::find($user_id);
            if($user_role) $list.=(($list=="")?"":" ; ").$user_role->name;
        }
        return $list;
    }


	public function getNbPermissionsAttribute()
	{
        $nb=DB::table('role_has_permissions')
            ->where('role_id', '=', $this->id)
            ->count();

	    return $nb;
	}


    //LOG
    public function log_transaction($url,$operation,$values="") {
        $log=new Logs;
        if($values=="") {
          $t_values=$this->getAttributes();
          foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value;
        }
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }

    public function getDroits()
	{
		$user=Auth::user();
	    $liste_permissions="";
		$permissions_role =  DB::table('permission_role')->select('permission_id')->where('role_id', '=', $this->id)->get();
		$t_perm=array();
		foreach ($permissions_role as $permission_role) $t_perm[]=$permission_role->permission_id;

		$permissions = Permission::wherein('id',$t_perm)->orderby('display_name')->get();
		foreach ($permissions as $permission)
		{
		    $liste_permissions .=(($liste_permissions=="")?"":"\n\r"."<br/>").$permission->display_name;
		}
	    return $liste_permissions;
	}


    /* SUPPRESSION */
    function getIsSupprimableAttribute() {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("ROL_SUP")) return false;

        if($this->NbPermissions>0) return false;
        if($this->getusers()) return false;

        return true;
    }

    /* Modifiable */
    function getIsModifiableAttribute() {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("ROL_MAJ")) return false;
        return true;
    }

}
