<?php namespace App\Models\Sipre;

use Illuminate\Database\Eloquent\Model;
use App\Models\Allocataire;
use DB;
class SipreBeneficiaire extends Model {


	protected $table = 'beneficiaires';
    protected $connection = 'mysql2';
    //protected $primaryKey = 'id';


    /* Dates */
    public function getDates()
    {
            return array('datenaiss','ret_dateed','date_pi','updated_at');
    }


    public function getDateNaissFRAttribute($value)
    {
        return ($this->attributes['datenaiss']!=null)?date('d/m/Y', strtotime($this->attributes['datenaiss'])):null;
    }

     public function getDateDecesFRAttribute($value)
    {
        return ($this->attributes['date_deces']!=null)?date('d/m/Y', strtotime($this->attributes['date_deces'])):null;
    }

     public function getRetDateedFRAttribute($value)
    {
        return ($this->attributes['ret_dateed']!=null)?date('d/m/Y', strtotime($this->attributes['ret_dateed'])):null;
    }
     public function getDatePiFRAttribute($value)
    {
        return (($this->attributes['date_pi']!=null))?date('d/m/Y', strtotime($this->attributes['date_pi'])):null;
    }
    public function getUpdatedAtFRAttribute($value)
    {
        return ($this->attributes['updated_at']!=null)?date('d/m/Y', strtotime($this->attributes['updated_at'])):null;
    }
    
    /* SITS */
    /* IdSITAS */
    public function getIdSITASAttribute()
    {
        $allocataire=Allocataire::where('id_cpswf','=',$this->id)->first();

        if(!$allocataire) return "";
        return $allocataire->IdPAD;
    }

    /* IdSITAS */
    public function getInfoDetailAides()
    {
        $allocataire=Allocataire::where('id_cpswf','=',$this->id)->first();
        if(!$allocataire) return "";
        return $allocataire->getInfoDetailAides();
    }
    /* IdSITAS */
    public function getQFAttribute()
    {
        $allocataire=Allocataire::where('id_cpswf','=',$this->id)->first();
        if(!$allocataire) return "";
        return $allocataire->qf;
    }
    /* ***************************** */



    public function getIdPADAttribute()
    {
        return str_pad($this->id, 5, "0", STR_PAD_LEFT);
    }

    /* Nom */
    public function getNomCompletAttribute()
    {
            return $this->nom." ".$this->prenom;
    }


    /* Conjoint */
    public function getNomConjointAttribute()
    {
        $nom_conjoint="";
        $conjoint  = SipreBeneficiaire::where('id', '=', $this->conjoint)->first();
        if($conjoint) $nom_conjoint =trim($conjoint->nom)." ".trim($conjoint->prenom);
        return $nom_conjoint;
    }


    // ALlocations */
    public function getAllocationsMontantAttribute()
    {
        $montant=0;
        $date_lim=date('Y-m', strtotime('-3 month'))."-01";
        //Dernier allocations
        $last_versement  = SipreVersement::where('benum', '=', $this->id)
            ->where('type', '=', 'ALL')
            ->where('date', '>=', $date_lim)
            ->orderby('id', 'DESC')
            ->limit('1')
            ->first();
        if(!$last_versement) return 0;
        $montant=$last_versement->montant_c;
        return $montant;
    }


    public function getRetraiteMontantAttribute()
    {
        $montant=0;
        $date_lim=date('Y-m', strtotime('-3 month'))."-01";
        //Dernier allocations
        $last_versement  = SipreVersement::where('benum', '=', $this->id)
            ->where('type', '=', 'RET')
            ->where('date', '>=', $date_lim)
            ->orderby('id', 'DESC')
            ->limit('1')
            ->first();
        //if($this->id==147) dd($last_versement->id);
        if(!$last_versement) return 0;
        $montant=$last_versement->montant_c;
        return $montant;
    }

     /* Nb Enfants */
    public function getNbEnfantsAttribute()
    {
        $nb = SipreEnfant::where('parents1', '=', $this->id)
            ->orwhere('parents2', '=', $this->id)
            ->count();
        return $nb;
    }

    
    /* Nb Enfants */
    public function getEnfants()
    {
        $enfants = SipreEnfant::where('parents1', '=', $this->id)
            ->orwhere('parents2', '=', $this->id)
            ->get();
        return $enfants;
    }

        /**
     * Nombre d'enfants pour Aide Sociale
     */
    public function getNbEnfantsAAEAttribute()
    {
        $nb=DB::connection('mysql2')->table('enfants')
        ->where('parents1', '=', $this->id)
        ->whereIn('certif',array('1','2','3','4'))
        ->count();
        return $nb;
    }

}
