<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use \Venturecraft\Revisionable\RevisionableTrait;

class Versement extends Model
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'versements';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    /* Dates */
    public function getDates()
    {
        return array('date','procuration_date_naissance','procuration_date_debut','procuration_date_fin','updated_at','created_at');
    }


    public function getProcurationDateNaissanceAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateNaissanceUSAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateDebutAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateDebutUSAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateFinAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getProcurationDateFinUSAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getDateAttribute($value)
    {
        return ($this->attributes['date']!=null)?date('d/m/Y', strtotime($this->attributes['date'])):null;
    }
    public function getDateUSAttribute($value)
    {
        return ($this->attributes['date']!=null)?date('Y-m-d', strtotime($this->attributes['date'])):null;
    }

    public function getIdPADAttribute()
    {
        return str_pad($this->id, 5, "0", STR_PAD_LEFT);
    }

    public function getNumImpPADAttribute()
    {
        return str_pad($this->num_imp, 4, "0", STR_PAD_LEFT);
    }
    
	public function getAllocataire()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        if(!$allocataire) return "";
        return $allocataire;
    }

	public function getIsMonoparentAttribute()
    {
        $allocataire=$this->getAllocataire();
       if(!$allocataire->FamilleIdConjoint) return true;
       return false;
    }
  

	public function getAllocataireIdPADAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->IdPAD;
    }

	public function getAllocataireNomCompletAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }

	public function getAllocataireNomCompletReduit($taille_max=20)
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->getNomCompletReduit($taille_max);
    }

	public function getAllocataireDateNaissanceAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->DateNaissance;
    }

	public function getEtatCivilAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->EtatCivil;
    }
    

	public function getAdresseAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->adresse;
    }

	public function getTelephoneAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->tel;
    }

    /* ********************* */
    /* ***     AGE
    /* ********************* */
	public function getTrancheAgeAttribute()
    {
		$res="";
		$liste_ages_allocataire=MyApp::AGE_ALLOCATAIRES_TRANCHES; //['0-18'=>'Mineur','18-30'=>'18/30','30-60'=>'30/60','60-999'=>'+60'];
        $allocataire=$this->getAllocataire();
		$age=$allocataire->getAgeDate($this->DateUS);//Age;
		foreach($liste_ages_allocataire as $key=>$tranche) {
			$t=explode("-",$key);
			if(($age>=$t[0])&&($age<$t[1])) {$res=$key;break;}
		}
        return $res;
    }

	public function getTrancheAgeCSRAttribute()
    {
		$res="";
		$liste_ages_allocataire=MyApp::CSR_AGE_TRANCHES; //['0-70'=>'60/70','70-80'=>'70/80','80-999'=>'+480'];
        $allocataire=$this->getAllocataire();
		$age=$allocataire->getAgeDate($this->DateUS);//Age;
        
		foreach($liste_ages_allocataire as $key=>$tranche) {
			$t=explode("-",$key);
			if(($age>=$t[0])&&($age<$t[1])) {$res=$key;break;}
		}
        return $res;
    }

    /* ********************* */
    /* ***     CONJOINT
    /* ********************* */

    /* CONJOINT */
    public function getConjointNomCompletAttribute()
    {
        $conjoint=Allocataire::find($this->id_conjoint);
        if(!$conjoint) return "";
        return $conjoint->NomComplet;
    }
    
    public function getTrancheRetraiteConjointCSRAttribute()
    {
		$res="";
		$liste_montants=MyApp::CSR_MONTANTS_RETRAITE; //['0-42000'=>'<42000','42001-50000'=>'42001-50000'...
        $retraite=(!$this->retraite_conjoint)?0:$this->retraite_conjoint;
		foreach($liste_montants as $key=>$tranche) {
			$t=explode("-",$key);
			if(($retraite>=$t[0])&&($retraite<$t[1])) {$res=$key;break;}
		}
        return $res;
    }


    /***********/
    /* CSR     */
    /***********/
    public function getCSRTrancheQFAttribute()
    {
		$res="";
		$liste_montants=MyApp::CSR_MONTANTS_QF; //
        $qf=(!$this->qf)?0:$this->qf;
        
		foreach($liste_montants as $key=>$tranche) {
			$t=explode("-",$key);
			if(($qf>=$t[0])&&($qf<$t[1])) {$res=$key;break;}
		}
        return $res;
    }

    /* ********************* */
    /* ***       ENFANTS  ** */
    /* ********************* */
	public function getAllocataireNbEnfantsAAEAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NbEnfantsAAE;
    }
	
    public function getEnfantsAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        $enfants=$allocataire->getEnfantsAAE();
        return $enfants;
    }

	public function getMoisAttribute()
    {
        $mois=date('m', strtotime($this->attributes['ret_date']));
        $libelle=MyApp::MOIS_NUM[$mois];
        return $libelle;
    }

    /***********/
    /* FSO     */
    /***********/
    public function getRaisonLibelleAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        $lib=MyApp::getZBaseLibelle("BEN_RAISONS_FSO",$allocataire->raison_fso,'');

      return $lib;
    }


    /* CATEG REVENU */

	public function getCategorieRevenuAttribute()
    {
		$res="";
		$liste_qf=MyApp::CAT_REVENUS_FOYER; //CAT_REVENUS_FOYER
		$qf=$this->qf;
		foreach($liste_qf as $key=>$tranche) {
			$t=explode("-",$key);
			if(($qf>=$t[0])&&($qf<$t[1])) {$res=$key;break;}
		}
        return $res;
    }

    /* ********************* */
    /* ***     BANQUE
    /* ********************* */
	public function getBanqueNomAttribute()
    {
        $banque=Banque::find($this->id_banque);
        if($banque) return $banque->nom;
        return "";
    }

    //Vérification si compte bancaire OK (>=21)
	public function getCompteOKAttribute()
    {
        $size_IBAN=MyApp::SIZE_IBAN;
        if(strlen($this->compte)==$size_IBAN) return true;
        return false;
    }

    //Revoi la liste des erreurs sur le RIB
	public function getCompteError($sep="<br/>")
    {
        $error="";$size_IBAN=MyApp::SIZE_IBAN;
        if(strlen($this->compte)==0) $error="Aucun IBAN de défini";
        else {
            if(!$this->CompteOK) $error="IBAN comprends ".strlen($this->compte)." au lieu des ".$size_IBAN." caractères attendus";
            /*
            $nb=0;
            foreach(MyApp::FORMAT_COMPTE_IBAN as $champ=>$taille) {
                $champs="";
                if(strlen(trim($this->{$champ})!=$taille)) {
                    $champs=(($champs!="")?$sep:"").$champ;
                    $nb++;
                }
            }
            $error="Mauvais format pour ".(($nb==1)?"le":"les")." champ".(($nb==1)?"":"s")." : ".$champs;
            */
        }
        return $error;
    }
}