<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use \Venturecraft\Revisionable\RevisionableTrait;

class VersementRefus extends Model
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'versements_refus';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    /* Dates */
    public function getDates()
    {
        return array('date','procuration_date_naissance','procuration_date_debut','procuration_date_fin','updated_at','created_at');
    }


    public function getProcurationDateNaissanceAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateNaissanceUSAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateDebutAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateDebutUSAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateFinAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getProcurationDateFinUSAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getDateAttribute($value)
    {
        return ($this->attributes['date']!=null)?date('d/m/Y', strtotime($this->attributes['date'])):null;
    }
    public function getDateUSAttribute($value)
    {
        return ($this->attributes['date']!=null)?date('Y-m-d', strtotime($this->attributes['date'])):null;
    }


    public function getIdPADAttribute()
    {
        return str_pad($this->id, 5, "0", STR_PAD_LEFT);
    }
    
	public function getAllocataire()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        if(!$allocataire) return "";
        return $allocataire;
    }

	public function getAllocataireIdPADAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->IdPAD;
    }

	public function getAllocataireNomCompletAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }

	public function getAllocataireDateNaissanceAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->DateNaissance;
    }

	public function getEtatCivilAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->EtatCivil;
    }
    

	public function getAdresseAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->adresse.(($allocataire->boite_postale)?" - BP".$allocataire->boite_postale:"");
    }

	public function getTelephoneAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->tel;
    }

    /***************/
    /* FILET SOCIAL    */
    /***************/
    // type_res=D pour détail du calcul
    public function  getCalculMontantFSOAttribute()
    {
        $famille=$this->getFamille();
        //$famille=$this->getFamille();
        //if($famille) {
        //    $montant=$famille->getCalculMontantFSO();
        //} else {
            $montant=$this->CalculFSO;
        //}
        return $montant;
    }

    public function getRaisonLibelleAttribute()
    {
      $lib=MyApp::getZBaseLibelle("BEN_RAISONS_FSO",$this->raison_fso,'');

      return $lib;
    }

    
    /* ********************* */
    /* ***     CONJOINT
    /* ********************* */

    /* CONJOINT */
    public function getConjointNomCompletAttribute()
    {
        $conjoint=Allocataire::find($this->id_conjoint);
        if(!$conjoint) return "";
        return $conjoint->NomComplet;
    }



}