@extends('layouts.dash')
@section('title') Allocataires @stop
@section('title_card')  @stop

@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif

        {{ html()->form('POST', url('/set_refus_'.strtolower($type_aide)))->open() }} 
            <input type="hidden" name="list_check" id='list_check' value="">
            <input type="hidden" name="type_aide" id='list_check' value="{{ $type_aide }}">


        <div class="card-header bg-info">
            <h2 class="card-title">{{ $title }}</h2>
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-2'>
                    {!! html()->label('Filtre','select_filtre') !!}
                    {!! html()->select('select_filtre',$filtres,isset($filtre)?$filtre:"")
                            ->placeholder('Tous')->attributes(['class' => 'form-control','id' => 'select_filtre'])  !!}
                </div>
                <div class="col-md-3">
                    {!! html()->label( 'Raison du Refus à appliquer','raison_fso') !!}
                    {!! html()->select('raison_fso',$raisons_fso,null)
                            ->placeholder('A définir')
                            ->attributes(['id' => 'raison_fso','class' => 'form-control'])  !!}
                </div>
                @if(count($t_lignes)>0)
                    <div class="col-md-7" style="padding-top:35px">
                        <button type="submit" class="btn btn-success" id="btn_maj"
                            onclick='if(!confirm("Voulez-vous vraiment mettre à jour la raison de refus pour les Allocataires selectionnés ?")) return false;'>Mettre à jour le statut</button>
                        <span id="libelle_select" class="text-danger">dd</span>
                    </div>
                @endif
            </div>
            </div>
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width="1px" nowrap>Sel.
                            <input id="box_all" class="form-control" name="sel" type="checkbox" value="1">
                        </th>
                        <th width='1px'>Id</th>
                        <th width='1px'>Dossier<br/>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th width='1px'>Date de naissance</th>
                        <th width='1px'>Age</th>
                        <th >Conjoint</th>
                        <th width='1px'>NbPersonnes</th>
                        <th width='1px'>Ressources</th>
                        <th width='1px'>QF</th>
                        <th width='1px'>Refus</th>
                        <th width='1px'>Montant</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($allocataires as $allocataire)
                        <tr>
                            <td style='margin:0px'>
                                <input id="box_{!! $allocataire->id !!}" class="form-control box_select" name="box_{!! $allocataire->id !!}" type="checkbox" value="1">
                            </td>
                            <td  >
                                <a class="btn bg-secondary" href="{!! url('allocataires/'.$allocataire->id) !!}">{!! $allocataire->IdPAD !!}</a>
                            </td>
                            <td>
                                @if($allocataire->id_famille)
                                    <a class="btn bg-primary" href="{!! url('familles/'.$allocataire->id_famille) !!}">{!! $allocataire->IdPADFamille !!}</a>
                                @else
                                    <span class="badge badge-info right"> Aucun</span>
                                @endif
                            </td>
                            <td>{!! $allocataire->IdCPSWFPAD !!}</td>
                            <td>{!! $allocataire->nom_complet2 !!}</td>
                            <td align="center">{!! $allocataire->date_naissance !!}</td>
                            <td align="center">{!! $allocataire->age !!}</td>
                            <td>{!! $allocataire->FamilleConjointNomComplet !!}</td>
                            <td align="right">{!! $allocataire->FamilleNbPersonnes !!}</td>
                            <td align="right">{!! $allocataire->FamilleMontantRessources !!}</td>
                            <td align="right">{!! $allocataire->QF !!}</td>
                            <td align="left">{!! $allocataire->RaisonLibelle !!}</td>
                            <td align="right">{!! $allocataire->CalculMontantFSO !!}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        {{ html()->form()->close() }}
    </div>
@endsection


@section('scripts')
<script>
    $(function () {
        $('#select_filtre').change(function() {filtre();});
        function filtre() {
            var filtre=$('#select_filtre').val();
            if(filtre=="") filtre=0;
            var url="{!! url('set_refus_'.strtolower($type_aide)) !!}"+"/"+filtre;
            location.href=url;
        }
        $('.box_select').change(function() {
            calcul_select();
        });
        $('#box_all').change(function() {
            select_all();
        });
        
        $('#raison_fso').change(function() {
            calcul_select();
        });

        function select_all() {
            var lst="";
            var t_lignes={!! json_encode($t_lignes) !!};
            var check=$('#box_all').prop('checked');
            if(check) check="checked";
            for(var i=0;i<t_lignes.length;i++) {
                $('#box_'+t_lignes[i]).prop("checked",check);
                var checkbox=$('#box_'+t_lignes[i]).prop('checked');
                if(checkbox) {
                    lst+=((lst=="")?"":";")+t_lignes[i];
                }
            }
            set_list(lst);
        }

        function calcul_select() {
            var t_lignes={!! json_encode($t_lignes) !!};
            var lst="";
            var nb=0;
            for(var i=0;i<t_lignes.length;i++) {
                var check=$('#box_'+t_lignes[i]).prop('checked');
                if(check) {
                    lst+=((lst=="")?"":";")+t_lignes[i];
                    nb++;
                }
            }
            set_list(lst);
            
        }

        function set_btn() {
            let lst=$('#list_check').val();
            var nt_lst=lst.split(";");
            var nb = nt_lst.length;
            if(nb>0 && lst!="") {
                $('#btn_maj').attr('disabled',false);
                $('#libelle_select').html("Séléction de "+nb+" allocataires");
                var raison_fso=$('#raison_fso').val();
                if(raison_fso=="") $('#btn_maj').attr('disabled',true);
            } else {
                $('#btn_maj').attr('disabled',true);
                $('#libelle_select').html("Aucun allocataire séléctionné");
            }

        }
    
        function set_list(lst="") {
            $('#list_check').val(lst);

            var nt_lst=lst.split(";");
            var nb = nt_lst.length;
            set_btn()
        }

        function init_list() {
            var lst=$('#list_check').val();
            var nt_lst=lst.split(";");
            for(var i=0;i<nt_lst.length;i++) {
                $('#box_'+nt_lst[i]).prop('checked',true);
            }
            set_list(lst);
        }

        var table =$('#_table').dataTable( {
            bAutoWidth: false,bPaginate: false,bInfo: true,
            bFilter: true,
            //deferRender:    false,
            fixedHeader: true,
            
            //scrollCollapse: false,scroller:true,iDisplayLength:10,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher ",
                buttons: {
                    colvis: 'Colonnes',
                    copy: 'Copier',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }
                },
            dom: "<'row'<'col-sm-1 text-left'><'col-sm-4'><'col-sm-7 text-right'f>>" +
                "<'row'<'col-sm-12't>>B" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
                
            "buttons": ["copy", "excel", "colvis"],
            "columnDefs": [
                { "targets": [ 0], "orderable": false,"searchable": false, "visible": true},
            ]

        });

        init_list();
    });
  </script>
@endsection
