@extends('layouts.dash')
@section('title') Utilisateur @stop
@section('title_card')  @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-info">
        <div class="card-header">
            Changer d'Utilisateur
        </div>
        <div class='card-body'>
            {{ html()->form('PUT', url('change_profil'))->open() }}
                <div class="card-body">
                    <div class="col-lg-max col-lg-offset-1 container-fluid">
                        <div class="row col-md-5">
                            <div class="form-group">
                                {!! html()->label( 'Utilisateur','utilisateur') !!}
                                {!! html()->select('user_id',$users_list,DB::table('users')->where('id', '=', $user->id)->pluck("id"))
                                        ->placeholder('Choisissez un utilisateur')
                                        ->attributes(['class' => 'form-control'])  !!}
                            </div>
                        </div>

                        <div class='form-group'>
                            {!! html()->button('Valider')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                        </div>
                    </div>
                </div>
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop


