@extends('layouts.resetpwd')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    {!! 'Bonjour '.$formateur->prenom.' '.$formateur->nom !!}</div>

                <div class="card-body">

                    @if(isset($errors) && $errors!="")
                        <div class='bg-danger alert'>{!! $errors !!}</div>
                    @endif


                    @if($message!="")
                        <div class='bg-success alert'>{!! $message !!}</div>
                    @else
                         <div class='col-lg-10 col-lg-offset-1'>
                            <form class="form-horizontal" role="form"  method="POST" action="{!! url('/api/pwd_reset') !!}">
                            
                                {!! Form::hidden('code_api', $code_api) !!}
                                <input type="hidden" name="_token" value="{!! csrf_token() !!}">

                                @csrf

                                <div class='form-group'>
                                    <div class="col-xs-10">
                                        <h3>Vous devez créer votre nouveau mot de passe : </h3>
                                        <h4>Le mot de passe doit contenir au moins 8 à 12 caractères comprenant&nbsp;:  </h4>
                                            <ul margin-class='form-group' style="color:red">
                                                <li>au moins une lettre en majuscule</li>
                                                <li>au moins une lettre en minuscule</li>
                                                <li>au moins un chiffre</li>
                                                <li>au moins un caractère de type : @ # $ % & + =</li>
                                            </ul>
                                        
                                    </div>
                                </div>

                                <div class='form-group'>
                                    <div class="col-xs-5">
                                    {!! Form::label('password', 'Nouveau Mot de passe') !!}
                                    {!! Form::password('password', ['placeholder' => 'Mot de passe, 8 caractères au minimum', 'class' => 'form-control']) !!}
                                    </div>
                                </div>
                                <div class='form-group'>
                                    <div class="col-xs-5">
                                    {!! Form::label('password_confirmation', 'Confirmez le mot de passe') !!}
                                    {!! Form::password('password_confirmation', ['placeholder' => 'Mot de passe, 8 caractères au minimum', 'class' => 'form-control']) !!}
                                    </div>
                                </div>


                                <div class='form-group'>
                                    <div class="col-xs-4">
                                    {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
                                    </div>
                                </div>
                            {!! Form::close() !!}
                        </div>
                    @endif  

            </div>
        </div>
    </div>
</div>
@endsection




