@extends('layouts.dash')
@section('title') Bénéficiares CPSWF @stop
@section('title_card')  @stop

@section('content')
    <div class="card">
        <div class="card-header bg-info">
            <h2 class="card-title">{{ $title }}</h2>
        </div>
        <div class="card-body">
            <div class="row" style="padding-bottom:30px">
                <div class='col-md-4'>

                </div>
            </div>  
            @if(!isset($t_param['active']))
                <h4>La CPSWF ne partage pas actuellement les informations bénéficiaires</h4>
            @else
                <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th width='1px'>IdCPSWF</th>
                            <th width='1px'>IdSITAS</th>
                            <th width='1px'>AidesSITAS</th>
                            <th width='1px'>QFSITAS</th>
                            <th >Nom</th>
                            <th >Nom de naissance</th>
                            @if(isset($t_param['champ_naissance']))
                            <th width='1px'>Naissance</th>
                            @endif
                            @if(isset($t_param['champ_conjoint']))
                            <th>Conjoint</th>
                            @endif
                            @if(isset($t_param['nb_enfants']))
                            <th width='1px'>NbEnf</th>
                            @endif
                            @if(isset($t_param['nb_enfants_alloc']))
                            <th width='1px'>NbEnfAlloc.</th>
                            @endif
                            @if(isset($t_param['montant_retraite']))
                            <th width='1px'>Retraite</th>
                            @endif
                            @if(isset($t_param['montant_alloc']))
                            <th width='1px'>Allocations</th>
                            @endif
                            <th width='1px'>Statut</th>
                            @if(isset($t_param['observations']))
                            <th width='1px'>Observation</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($beneficiaires as $beneficiaire)
                            <tr>
                                <td >
                                    @if(1==1)<a class="btn btn-sm bg-info" target="_blank" href="{!! url('cpswf_benef/'.$beneficiaire->IdPAD) !!}">@endif
                                        {!! $beneficiaire->IdPAD !!}</td>
                                    @if(1==1)</a>@endif
                                <td >
                                    @if($beneficiaire->IdSITAS)<a class="btn btn-sm bg-secondary" target="_blank" href="{!! url('allocataires/'.$beneficiaire->IdSITAS) !!}">@endif
                                        {!! $beneficiaire->IdSITAS !!}
                                    @if($beneficiaire->IdSITAS)</a>@endif
                                </td>

                                <td >{!! $beneficiaire->getInfoDetailAides() !!}</td>
                                <td align='right'>{!! $beneficiaire->QF !!}</td>
                                <td >{!! $beneficiaire->NomComplet !!}</td>
                                <td >{!! $beneficiaire->nom_jf !!}</td>
                                @if(isset($t_param['champ_naissance']))
                                    <td >
                                        {!! $beneficiaire->DateNaissFR !!}
                                        @if($beneficiaire->DateDeces)
                                            {!! "Décédé le :".$beneficiaire->DateDeces !!}
                                        @endif
                                    </td>
                                @endif
                                @if(isset($t_param['champ_conjoint']))
                                <td >{!! $beneficiaire->NomConjoint !!}</td>
                                @endif
                                @if(isset($t_param['nb_enfants']))
                                <td >{!! $beneficiaire->nb_enf !!}</td>
                                @endif
                                @if(isset($t_param['nb_enfants_alloc']))
                                <td >{!! $beneficiaire->NbEnfantsAAE !!}</td>
                                @endif
                                @if(isset($t_param['montant_retraite']))
                                <td align='right'>{!! $beneficiaire->RetraiteMontant !!}</td>
                                @endif
                                @if(isset($t_param['montant_alloc']))
                                <td align='right'>{!! $beneficiaire->AllocationsMontant !!}</td>
                                @endif
                                <td >{!! $beneficiaire->statut  !!}</td>
                                @if(isset($t_param['observations']))
                                <td >{!! $beneficiaire->obs_vers !!}</td>
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>
@endsection


@section('scripts')

<script>
  $(function () {
    $.fn.dataTable.moment('D/M/YYYY');
    $("#_table").DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "responsive": false,
      "autoWidth": true,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12't>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
        "columnDefs": 
            [
                //{ "targets": [12], "orderable": true,"searchable": false, "visible": false},
            ],
        "buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv",
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
@endsection
