

@if(!$mode_frame)
    <div class="form-group row">
        <div class="col-md-6">
            {!! html()->label( 'Allocataire','id_allocataire') !!}
            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="allocataire_addon" id='allocataire_addon'>{!! isset($document->id_allocataire)?str_pad($document->id_allocataire, 6, "0", STR_PAD_LEFT):'' !!}</span>
                </div>
                {!! html()->text('allocataire', isset($document->id_allocataire)?$document->NomCompletAllocataire:'')
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'allocataire','class' => 'form-control'])
                !!}
            </div>
        </div>
    </div>
@endif

<div class="form-group row">
    <div class="col-md-4">
        {!! html()->label( 'Type de Document','type') !!}
        {!! html()->select('type',$types_documents,null)->placeholder('A définir')->attributes([($mode=="show"?'disabled':''),'class' => 'form-control'])  !!}
    </div>
    <div class="col-md-3">
        {!! html()->label( 'Date','date') !!}
        <div class='input-group date' id='datepicker_date'>
            {!! html()->text('date', date('d/m/Y'))->placeholder('')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control','style' => 'text-align:center']) !!}
            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
    @if($mode=="show") 
        <div class="col-md-1 pt-4" >
            <a href="{{ $document->URL }}" target='_blank' >
                <img src="{!! url('/img/'.$document->Icone) !!}" style="padding-top:8px" width="40px" alt="Cliquer pour voir le fichier" class="" >
            </a>  
        </div>  
    @endif
</div>

@if($mode=="create") 
<div class="form-group row">
    <div class="col-md-12">
        {!! html()->file('doc_file')->attributes(['id'=>'doc_file','name'=>'doc_file','title'=>'Choisir le document .jpg,.png,.pdf (1,5Mo maxi)','class'=>'form-control-file','style'=>'visibility:hidden','accept'=>'.jpg,.png,.pdf']) !!}
        {!! html()->label('&nbsp;+&nbsp;Ajouter le fichier','doc_file')->attributes(['id'=>'btn_file','class'=>'btn btn-md btn-info']) !!} 
        <span id="nom_doc" class="text-primary"></span>
    </div>
</div>
@endif

<div class="form-group row">

</div>

<div class="form-group row">
    <div class='col-md-12'>
        {!! html()->label( 'Description','description') !!}
        {!! html()->textarea('description', null)
            ->placeholder('')
            ->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control', 'rows'=>'2']) !!}
    </div>
</div>



<div class='form-group'>
    @if($mode=="show")
        @if($user->hasRole("ADMINISTRATEUR") || $user->can("DOC_MAJ"))
            @if($mode_frame) 
                <a class="btn btn-primary" href="{!! url('/allocataires_maj_documents_pop/'.$document->id) !!}">Modifier</a> 
            @else 
                <a class="btn btn-primary" href="{!! url('/documents/'.$document->id.'/edit') !!}">Modifier</a> 
            @endif
        @endif
        @if($mode_frame) 
            <a class="btn btn-danger" href="{!! url('/allocataires_delete_documents_pop/'.$document->id) !!}" onclick="if(!confirm('Voulez-vous vraiment supprimer ce Document ?')) return false;">Supprimer</a> 
        @else
            {{ html()->form('DELETE', url('/documents/'. $document->id))->open() }}
                <button class="btn btn-danger" onclick="if(!confirm('Voulez-vous vraiment supprimer ce Document ?')) return false;">Supprimer</button>
            {{ html()->form()->close() }}
        @endif
    @else
        {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
    @endif
    @if(!$mode_frame) 
    <a class="btn btn-warning"  href="{!! url('documents') !!}">Retour</a>
    @endif
</div>


