@extends('layouts.dash_pop')

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{{ Session::get('message') }}</div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    @else
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card">
            <div class="card-header bg-warning">
                <h2 class="card-title">Ajouter un enfant</h2>
            </div>
            <div class='card-body'>
                {{ html()->form('POST', url('famille_add_enfant/'.$famille->id ))->open() }}
                    <input type="hidden" name="id_famille" value="{{ $famille->id }}">
                    <input type="hidden" name="id_enfant" id="id_enfant" value="">

                    <div class='form-group row'>
                        <div class="col-md-12">
                            {!! html()->text('nom', null)
                            ->placeholder('Rechercher...')
                            ->attributes(['id'=>'nom_find', 'class' => 'form-control text-uppercase']) !!}
                        </div>
                    </div>
                    <div class='form-group row'>
                        <div class="col-md-2">
                            {!! html()->button('Sélectionner')->value('Sélectionner')->type('submit')->attributes(['id'=>'btn_selection','class' => 'btn btn-success']) !!}
                            {!! html()->a(url(''),"Nouveau")->attributes(['id'=>'btn_nouveau','class' => 'btn btn-warning'])  !!}
                        </div>
                    </div>


                {{ html()->form()->close() }}
            </div>
        </div>
    @endif
@stop


@section('scripts0')
    <script type="text/javascript">
        $('#btn_selection').hide();
        $('#btn_nouveau').hide();
        //Saisie conjoint
        $("#nom_find").autocomplete({
            source: "{!! url('auto_famille_enfant') !!}",
            minLength: 2,
            autofocus:true,
            select: function(event, ui) {
                var id=ui.item.id;
                var idPAD=id.toString().padStart(5,"0");
                $('#id_enfant').val(id);
                if(id) {
                    $('#btn_selection').show();
                    $('#btn_nouveau').hide();
                }
                else {
                    $('#btn_selection').hide();
                    $('#btn_nouveau').show();
                }
            },
            change: function( event, ui ) {
            }
        });
    </script>

@stop
