@extends('layouts.dash')
@section('title') Dossiers Familles @stop

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header bg-primary">
            <h3 class="card-title">Liste des Familles</h3>
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-2'>
                    {!! html()->label('Ile','select_ile') !!}
                    {!! html()->select('select_ile',App\Models\MyApp::ILES,isset($ile)?$ile:"")->placeholder('Toutes')->attributes(['class' => 'form-control','id' => 'select_ile'])  !!}
                </div>
                <div class='col-md-4'>
                    {!! html()->label('Aide','select_aide') !!}
                    {!! html()->select('select_aide',App\Models\MyApp::TYPES_AIDES,isset($aide)?$aide:"")->placeholder('Toutes')->attributes(['class' => 'form-control','id' => 'select_aide'])  !!}
                </div>
            </div>
            <div class="row">
                <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover" >
                    <thead>
                        <tr>
                            <th width='1px'>Id</th>
                            <th width='40%'>Parents</th>
                            <th width='40%'>Enfants (-21a)</th>
                            <th width='1px'>NbEnfants<br/>Tot/Soc</th>
                            <th width='1px'>NbPersonnes</th>
                            <th width='20%'>Membres</th>
                            <th width='20%'>Membres<br/>Sans Statut</th>
                            <th width='1px'>Village</th>
                            <th width='1px'>Ressources</th>
                            <th width='1px'>QF</th>
                            <th width='1px'>Statut<br/>Titulaire</th>
                            <th width='1px'>Aides</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($familles as $famille)
                            <tr>
                                <td><a class="btn bg-secondary " href="{{ url('familles/'.$famille->id) }}" >{!! $famille->IdPAD !!}</a></td>
                                <td>{!! $famille->getParentsListe() !!}</td>
                                <td>{!! $famille->getEnfantsLessListe() !!}</td>
                                <td align="center">{!! $famille->NbEnfants."/".$famille->NbEnfantsAAE !!}</td>
                                <td align="center">{!! $famille->NbPersonnes !!}</td>
                                <td>{!! $famille->getMembresListe() !!}</td>
                                <td>{!! $famille->getAutresMembresListe() !!}</td>
                                <td>{!! $famille->VillageNomComplet !!}</td>
                                <td align="right">{!! $famille->MontantRessources !!}</td>
                                <td align="center">{!! $famille->QF !!}</td>
                                <td>{!! $famille->StatutTitulaire !!}</td>
                                <td>{!! $famille->getAides() !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")

    <script>
        $(function () {
            $('#select_aide').change(function() {select_filtre();});
            $('#select_ile').change(function() {select_filtre();});

            function select_filtre() {
                var aide=$('#select_aide').val();
                if(aide=="") aide=0;
                var ile=$('#select_ile').val();
                if(ile=="") ile=0;
                var url="{!! url('familles_filtre') !!}"+"/"+ile+"/"+aide;
                location.href=url;
            }
        });
    </script>

@endsection
