@extends('layouts.dash')
@section('title') Famille @stop

@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="content-header" style='text-align:center;'>
        <h2 style='color:darkblue'>Dossier Famille <span >{!! $famille->IdPAD.(($titulaire)?"-".$titulaire->NomComplet:" - Aucun Titulaire") !!}</span></h2>
        
        <h4><span >{!! ($titulaire)?$titulaire->AdresseComplete:"" !!}</span></h4>

        <h5 class="text-primary">
            <small >Ressources : {!! ($famille)?number_format($famille->MontantRessources,0,","," "):"" !!}CFP</small>
            <small >QF : {!! ($famille)?number_format($famille->QF,0,","," "):"" !!}CFP</small>
        </h5>
        
    </div>
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif
    {{ html()->modelForm($famille, 'PUT', url('familles/' . $famille->id))->open() }}
        @include("familles.content")
    {{ html()->closeModelForm() }}

    @if($famille->canDelete)
    <a href="{{ url('famille_delete/'.$famille->id) }}" onclick="if(!confirm('Voulez-vous supprimer cette famile définitivement ?'))  return false; " title="Supprimer la famille définitivement" class="btn btn-sm btn-danger"  >
        <i class="fas fa-trash"></i></a>
    </a>
    @endif
@stop

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    @include("familles.scripts_familles")
@stop
