@extends('layouts.dash')
@section('title') Paramêtres @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @include("param.parametres.content_taux")
@endsection

@section('scripts')
    <script>
        $(function () {
            $("[name='btn_modif']").click(function() {
                var id = $(this).attr("id");
                var btn=$("#"+id);
                var name_field = id.replace('btn_','');
                var label=btn.html();
                if(label=="Modifier") {
                    $('#'+name_field).attr('disabled',false)
                    btn.html("Valider");
                    btn.toggleClass('bg-info bg-success');
                    btn.removeClass('bg-info');
                }
                if(label=="Valider") {
                    var value=$('#'+name_field).val();
                    var field=name_field;  
                    btn.html("Modifier"); 
                    $('#'+name_field).attr('disabled',true);
                    btn.toggleClass('bg-success bg-info');
                    $.ajax({
                        url: "{{ route('postParam') }}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            value: value,
                            field: field,
                        },
                        success: function(data) {
                            // log response into console
                            if(data) alert('Modification enregistrée');
                            else alert('Enregistrement non effectué');
                            location.reload();
                        }
                    }); 
                }
            });

            $('#btn_valide').click(function() {
                alert('ee');
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });


            function select_filtre() {

            }
        });
    </script>
@endsection