@extends('layouts.dash')
@section('title') Paramêtres @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    
    <div class="card card collapsed-card">
        <div class="card-header">
            <h3 class="card-title">CSR</h3>
            <div class="card-tools">
              <button type="button" class="btn btn-tool"data-card-widget="collapse">
                <i class="fas fa-plus"></i>
              </button>
            </div>
        </div>
        <div class='card-body'>
            @foreach ($parametres as $parametre)
                <div class="row form-group"> 
                    @if($parametre->type=="N")
                        <div class="col-mg-4">
                            {!! html()->label($parametre->info,$parametre->ref)->attributes(['style'=>'']) !!}
                            {!! html()->text($parametre->ref, $parametre->value)->attributes(['size' => '10','placeholder' => '', 'class' => 'form-control']) !!}
                        </div>
                    @endif
                    @if($parametre->type=="T")
                        <div class="col-mg-4">
                            {!! html()->label($parametre->info,$parametre->ref)->attributes(['style'=>'']) !!}
                            {!! html()->text($parametre->ref, $parametre->value)->attributes(['placeholder' => '', 'class' => 'form-control']) !!}
                        </div>
                    @endif  
                </div>                
            @endforeach
        </div>
    </div>

@endsection





@section('scripts')
@endsection