@extends('layouts.dash')
@section('title') Historique des modifications @stop
@section('subtitle_card',"")

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>{{ $titre }}</h3>
        </div>
        <div class="card-body">
            <table id="_table" class="table table-condensed table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Banque</th>
                        <th>Titulaire</th>
                        <th>Compte</th>
                        <th>Actif</th>
                        <th>User</th>
                        <th>Info</th>
                        <th>Date</th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($comptes as $compte)
                    <tr>
                        <td>{!! $compte->id !!}</td>
                        <td>{!! $compte->BanqueNom !!}</td>
                        <td>{!! $compte->titulaire  !!}</td>
                        <td>{!! $compte->Compte !!}</td> 
                        <td>{!! $compte->actif  !!}</td> 
                        <td>{!! $compte->UserName !!}</td> 
                        <td>{!! $compte->infomodif  !!}</td>
                        <td>{!! $compte->date !!}</td> 
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('scripts')
<script>
  $(function () {
    $.fn.dataTable.moment('D/M/YYYY');
    $("#_table").DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "responsive": false,
      "autoWidth": true,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12't>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

        "buttons": ["copy", "excel"] //"print", "pdf", "csv",, "colvis"
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
@endsection


