<!-- *** AIDE A L'ENFANT *** -->
<h5><span>Nombre d'enfants concernés : {{ $allocataire->NbEnfantsAAE }}</span></h5>
<div>
    <ul>
        @foreach($allocataire->getEnfantsAAE() as $enfant)
            <li><b>{{ $enfant->NomComplet." ".$enfant->Age."ans : " }}</b> <span class="text-muted">{{ "Certificat ".$enfant->certificat_enfant." - ".$liste_certificats[$enfant->certificat_enfant] }}</span></li>
        @endforeach
    </ul>
</div>

<div class="form-group row">
    <div class="col-md-2">
        {!! html()->label( "Ouverture",'date_ouverture_aae') !!}
        <div class='input-group date' id='datepicker_date_ouverture_aae'>
            {!! html()->text('date_ouverture_aae', null)
                ->placeholder('')
                ->attributes([($mode=="show" || !$maj_aide)?'disabled':'','class' => 'form-control']) !!}
            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
    <div class="col-md-2">
        {!! html()->label( "Fermeture",'date_fermeture_aae') !!}
        <div class='input-group date' id='datepicker_date_fermeture_aae'>
            {!! html()->text('date_fermeture_aae', null)
                ->placeholder('')
                ->attributes([($mode=="show" || !$maj_aide)?'disabled':'','class' => 'form-control']) !!}
            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
    <div class="col-md-8">
        {!! html()->label('Motif','fermeture_aae_motif',) !!}
        {!! html()->textarea('fermeture_aae_motif', null)->attributes([($mode=="show" || !$maj_aide)?'disabled':'', 'class' => 'form-control', 'rows'=>'2']) !!}
    </div>
</div>

<div class="form-group row">
    <div class="col-md-3 text-success">
        {!! html()->label( 'Montant pour '.$allocataire->NbEnfantsAAE.' Enf.','montant_aae') !!}
        <div class="input-group mb-4">
            {!! html()->text('montant_aae', null)->placeholder('Montant')->attributes(['id' => 'montant_aae','disabled', 'class' => 'text-success text-right form-control']) !!}
            <div class="input-group-append">
                <span class="input-group-text ">CFP</span>
            </div>
        </div>
    </div>
    <div class="col-md-3 text-danger">
        {!! html()->label( 'Montants rappel','rappel_aae') !!}
        <div class="input-group mb-4">
            {!! html()->text('rappel_aae', null)->placeholder('Montant rappel')->attributes(['id' => 'rappel_aae',($mode=="show" || !$maj_aide)?'disabled':'', 'class' => 'text-danger text-right form-control']) !!}
            <div class="input-group-append">
                <span class="input-group-text">CFP</span>
            </div>
        </div>
    </div>
    @if($prime)
        <div class="col-md-3 text-info">
            {!! html()->label( 'Prime '.App\Models\MyApp::getDatePrimeExcept(),'prime') !!}
            <div class="input-group mb-3">
                {!! html()->text('prime',$prime)
                    ->placeholder('')
                    ->attributes(['id' => 'rappel_aae',($mode=="show" || !$maj_aide)?'disabled':'', 'class' => 'text-danger text-right form-control']) !!}
                <div class="input-group-append">
                    <span class="input-group-text">CFP</span>
                </div>
            
            </div>
        </div>
    @endif
    <div class="col-md-3 text-danger">
        {!! html()->label( 'Total à verser','total_aae') !!}
        <div class="input-group mb-4" >
            {!! html()->text('total_aae', null)
                    ->attributes(['id' => 'total_aae','disabled', "style"=>"font-weight:bold", 'class' => 'text-danger text-right form-control']) !!}
            <div class="input-group-append">
                <span class="input-group-text">CFP</span>
            </div>
        </div>
    </div>
</div>


<div class="form-group row">
    <div class="col-md-12">
        {!! html()->label('Observations destinées au prochain versement','obs_aae',) !!}
        {!! html()->textarea('obs_aae', null)->attributes([($mode=="show" || !$maj_aide)?'disabled':'', 'class' => 'form-control', 'rows'=>'3']) !!}
    </div>
</div>

<div class="form-group row">
    <div class="col-md-12">
        @if($allocataire->getLastVersement("AAE"))
            <a href="{!! url('attestation_pmt/AAE/'.$allocataire->id) !!}" 
                style="text-decoration:none;color:white" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Attestation de paiement</a>
        @else
            <p class="text-danger">Aucun versement encore effectué</p>
        @endif
    </div>
</div>

<div class="form-group row">
    <div class="col-md-12">
        {!! html()->label("Historique des versements Aides à l'Enfant",'hist_csr',) !!}
        <table id="_table_versements_aae" class="table table-condensed table-stripped table-bordered">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>N°Imp</th>
                    <th>Date</th>
                    <th>Montant Rappel</th>
                    <th>Montant</th>
                    <th>Total</th>
                    <th>Observations</th>
                </tr>
            </thead>
            <tbody>
                @foreach($versements as $versement)
                    @if($versement->type=="AAE")
                        <tr>
                            <td>{{ $versement->IdPAD }}</td>
                            <td>{{ $versement->NumImpPAD }}</td>
                            <td>{{ $versement->date }}</td>
                            <td align="right">{{ $versement->montant_r }}</td>
                            <td align="right">{{ $versement->montant }}</td>
                            <td align="right">{{ $versement->montant_r+$versement->montant }}</td>
                            <td>{{ $versement->observations }}</td>
                        </tr>
                    @endif
                @endforeach
            </tbody>
        </table>
    </div>
</div>


