<div class="form-group row">
    @if($conjoint)
        <div class="col-md-3 text-secondary">
            {!! html()->label( 'Montant Retraite du conjoint CPSWF','montant_retraite_conjoint') !!}
            <div class="input-group mb-3">
                {!! html()->text('montant_retraite_conjoint', $allocataire->RetraiteConjoint)->attributes(['disabled', 'class' => 'text-success text-right form-control']) !!}
                <div class="input-group-append">
                    <span class="input-group-text ">CFP</span>
                </div>
            </div>
        </div>
        <div class="col-md-9 text-secondary">
            <h6>Dernière mise à jour de la fiche conjoint CPSWF : {{ $conjoint->UpdatedAt }}</h6>
        </div>
    @else
        <div class="col-md-9 text-secondary">
            <h6>Aucun conjoint</h6>
        </div>
    @endif
</div>

<div class="form-group row">
    <div class="col-md-2">
        {!! html()->label( "Date d'ouverture",'date_ouverture_csr') !!}
        <div class='input-group date' id='datepicker_date_ouverture_csr'>
            {!! html()->text('date_ouverture_csr', null)
                ->placeholder('')
                ->attributes([($mode=="show" || !$maj_aide)?'disabled':'','class' => 'form-control']) !!}
            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
    <div class="col-md-2">
        {!! html()->label( "Date de fermeture",'date_fermeture_csr') !!}
        <div class='input-group date' id='datepicker_date_fermeture_csr'>
            {!! html()->text('date_fermeture_csr', null)
                ->placeholder('')
                ->attributes([($mode=="show" || !$maj_aide)?'disabled':'','class' => 'form-control']) !!}
            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
    <div class="col-md-8">
        {!! html()->label('Motif de fermeture','fermeture_csr_motif',) !!}
        {!! html()->textarea('fermeture_csr_motif', null)->attributes([($mode=="show" || !$maj_aide)?'disabled':'', 'class' => 'form-control', 'rows'=>'2']) !!}
    </div>
</div>

<div class="form-group row">
    <div class="col-md-3 text-success">
        {!! html()->label('Montant CSR','montant_csr') !!}
        <div class="input-group mb-3">
            {!! html()->text('montant_csr', null)->placeholder('Montant')->attributes(['id' => 'montant_csr','disabled', 'class' => 'text-success text-right form-control']) !!}
            <div class="input-group-append">
                <span class="input-group-text ">CFP</span>
            </div>
        </div>
    </div>
    <div class="col-md-3 text-danger">
        {!! html()->label( 'Montants rappel','rappel_csr') !!}
        <div class="input-group mb-3">
            {!! html()->text('rappel_csr', null)->placeholder('Montant rappel')->attributes(['id' => 'rappel_csr',($mode=="show" || !$maj_aide)?'disabled':'', 'class' => 'text-danger text-right form-control']) !!}
            <div class="input-group-append">
                <span class="input-group-text">CFP</span>
            </div>
        </div>
    </div>
    <div class="col-md-3 text-danger">
        {!! html()->label( 'Total à verser','total_csr') !!}
        <div class="input-group mb-3">
            {!! html()->text('total_csr', null)->attributes(['id' => 'total_csr','disabled', 'class' => 'text-danger text-right form-control']) !!}
            <div class="input-group-append">
                <span class="input-group-text">CFP</span>
            </div>
        </div>
    </div>
</div>

<div class="form-group row">
    <div class="col-md-12">
        {!! html()->label('Observations destinées au prochain versement','obs_csr',) !!}
        {!! html()->textarea('obs_csr', null)->attributes([($mode=="show" || !$maj_aide)?'disabled':'', 'class' => 'form-control', 'rows'=>'3']) !!}
    </div>
</div>

<div class="form-group row">
    <div class="col-md-12">
        @if($allocataire->getLastVersement("CSR"))
            <a href="{!! url('attestation_pmt/CSR/'.$allocataire->id) !!}" 
                style="text-decoration:none;color:white" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Attestation de paiement</a>
        @else
            <p class="text-danger">Aucun versement encore effectué</p>
        @endif
    </div>
</div>


<div class="form-group row">
    <div class="col-md-12">
        {!! html()->label('Historique des versements CSR','obs_csr',) !!}
        <table id="_table_versements_csr" class="table table-condensed table-stripped table-bordered">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>N°Imp</th>
                    <th>Date</th>
                    <th>Montant Rappel</th>
                    <th>Montant</th>
                    <th>Total</th>
                    <th>Observations</th>
                </tr>
            </thead>
            <tbody>
                @foreach($versements as $versement)
                    @if($versement->type=="CSR")
                        <tr>
                            <td>{{ $versement->IdPAD }}</td>
                            <td>{{ $versement->NumImpPAD }}</td>
                            <td>{{ $versement->date }}</td>
                            <td align="right">{{ $versement->montant_r }}</td>
                            <td align="right">{{ $versement->montant }}</td>
                            <td align="right">{{ $versement->montant_r+$versement->montant }}</td>
                            <td>{{ $versement->observations }}</td>
                        </tr>
                    @endif
                @endforeach
            </tbody>
        </table>
    </div>
</div>





