<div class="callout callout-primary">
    <!-- CONJOINT -->
    <div class="form-group row">
        <div class="col-md-6">
            {!! html()->label( 'Conjoint '.($conjoint && $conjoint->isTitulaire?'Titulaire':'Non Titulaire'),'nom_conjoint') !!}
            {!! html()->hidden('id_conjoint', $conjoint?$conjoint->id:'')->attributes(['id' => 'id_conjoint']) !!}
            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="conjoint_addon" id='conjoint_addon'>{!! $conjoint?$conjoint->IdPAD:"" !!}</span>
                </div>
                {!! html()->text('nom_conjoint', $allocataire?$allocataire->ConjointNomComplet:"")
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'nom_conjoint','class' => 'form-control'])
                !!}
            </div>
        </div>
        <div class="col-md-6" align="right" >
        @if((!$allocataire->id_famille))
            @if($allocataire->IdFamilleMembre)
                <span class="text-info">Membre de la Famille <a href="{{ url('familles/'.$allocataire->IdFamilleMembre) }}" target="_blank" class="btn btn-sm bg-info">{{ $allocataire->IdFamilleMembre}}</a></span>
            @elseif($allocataire->IdFamilleEnfant)
                <span class="text-info">Enfant (ou Personne à charge) de la Famille <a href="{{ url('familles/'.$allocataire->IdFamilleEnfant) }}" target="_blank" class="btn btn-sm bg-info">{{ $allocataire->IdFamilleEnfant}}</a></span>
            @else
                <span class="text-danger">Aucun Dossier Famille (allocataire seul) </span>
                @if($allocataire->age>=18)
                <span class="text-success"><a href="{{ url('familles_add_dossier/'.$allocataire->id) }}" onclick="if(!confirm('Voulez-vous vraiment créer un dossier famille pour cet allocataire ?')) return false;" class="btn btn-sm bg-success">Créer un dossier Famille </a></span>
                @endif
            @endif
        @else
            <span class="text-success">Dossier Famille <a href="{{ url('familles/'.$allocataire->id_famille) }}" target="_blank" class="btn btn-sm bg-success">{{ $allocataire->IdPADFamille}}</a></span>
            @if($allocataire->isTitulaire)
                <i title="Titulaire de la famille" class="btn btn-sm bg-warning fas fa-chess-king"></i>
            @endif
        @endif

    </div>
    </div>
    <!-- PARENTS -->
    <div class="form-group row">
        <div class="col-md-6">
            {!! html()->label( 'Parent1','nom_parent1') !!}
            {!! html()->hidden('id_parent1', null)->attributes(['id' => 'id_parent1']) !!}

            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="parent1_addon" id='parent1_addon'>{!! ($allocataire->id_parent1)?str_pad($allocataire->id_parent1, 6, "0", STR_PAD_LEFT):'' !!}</span>
                </div>
                {!! html()->text('nom_parent1', ($allocataire->id_parent1)?$allocataire->NomCompletParent1:'')
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'nom_parent1','class' => 'form-control'])
                !!}
            </div>
        </div>

        <div class="col-md-6">
            {!! html()->label( 'Parent2','nom_parent2') !!}
            {!! html()->hidden('id_parent2', null)->attributes(['id' => 'id_parent2']) !!}

            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="parent2_addon" id='parent2_addon'>{!! ($allocataire->id_parent2)?str_pad($allocataire->id_parent2, 6, "0", STR_PAD_LEFT):'' !!}</span>
                </div>
                {!! html()->text('nom_parent2', ($allocataire->id_parent2)?$allocataire->NomCompletParent2:'')
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'nom_parent2','class' => 'form-control'])
                !!}
            </div>
        </div>
    </div>
</div>

<! ------------- ENFANTS ----------------- ->
@if(isset($allocataire) && ($allocataire->IsTitulaire || $allocataire->IsConjoint))
    <div class="callout callout-secondary">
        <h4>Enfants du foyer 
            @if($allocataire->IsTitulaire)<small> comme titulaire</small>@endif
            @if($allocataire->IsConjoint)<small> comme conjoint</small>@endif
        </h4>
        <div class="form-group row"> 
            <div class="col-md-12" >
                <table id="_table_enfants" class="table table-condensed table-striped table-bordered" width="100%" >
                    <thead>
                        <tr>
                            <th width='1px'>Id</th>
                            <th>Nom</th>
                            <th>Prenom</th>
                            <th width='1px'>Date&nbsp;de&nbsp;naissance</th>
                            <th width='1px'>Age</th>
                            <th width='1px'>Sexe</th>
                            <th width='1px'>Certificat</th>
                            @if($mode=="show")
                            <th width='1px'>
                                @if($allocataire->IsTitulaire)
                                <a href="{!! url('allocataire_add_enfant/'.$allocataire->id) !!}" class="box_enfant fancybox.iframe">
                                    <button class="btn btn-sm btn-success" value="Ajouter un enfant" type="button">Ajouter un enfant</button>    
                                </a>  
                                @endif
                            </th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($famille_enfants as $enfant)
                            <tr>
                                <td>
                                    <a href="{!! url('allocataires/'.$enfant->Id) !!}" target="_blank" style="text-decoration:none"  class="btn btn-sm bg-secondary" >
                                        {!! $enfant->IdPAD !!}
                                    </a>
                                </td>
                                <td>{!! $enfant->NomComplet !!}</td>
                                <td nowrap>{!! $enfant->Prenom !!}</td>
                                <td align="center">{!! $enfant->DateNaissance !!}</td>
                                <td align="center">{!! $enfant->Age !!}&nbsp;ans</td>
                                <td align="center">{!! $enfant->Sexe !!}</td>
                                <td align="center">{!! $enfant->Certificat !!}</td>
                                @if($mode=="show")
                                <td nowrap>
                                    <a href="{!! url('enfants/'.$enfant->id) !!}" target="_blank" class="btn btn-sm  btn-warning">
                                        <span class='fas fa-eye'></span>
                                    </a> 
                                </td>
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <! ------------- MEMBRES ----------------- ->
    <div class="callout callout-secondary">
    <h4>Membres du foyer 
        @if($allocataire->IsTitulaire)<small> comme titulaire</small>@endif
        @if($allocataire->IsConjoint)<small> comme conjoint</small>@endif
    </h4>
    <div class="form-group row"> 
        <div class="col-md-12" >
            <table id="_table_membres" class="table table-condensed table-striped table-bordered" width="100%" >
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th >Nom</th>
                        <th >Prenom</th>
                        <th width='1px'>Date&nbsp;de&nbsp;naissance</th>
                        <th width='1px'>Age</th>
                        <th width='1px'>Sexe</th>
                        <th width='1px'>Rôle</th>
                        @if($mode=="show")
                        <th width='1px'>
                            @if($allocataire->IsTitulaire)
                            <a href="{!! url('allocataire_add_membre/'.$allocataire->id) !!}" class="box_enfant fancybox.iframe">
                                <button class="btn btn-sm btn-success" value="Ajouter un Membre" type="button">Ajouter un membre</button>    
                            </a>  
                            @endif
                        </th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @foreach ($famille_membres as $membre)
                        <tr>
                            <td>
                                <a href="{!! url('allocataires/'.$membre->Id) !!}" target="_blank" style="text-decoration:none"  class="btn btn-sm bg-secondary" >
                                    {!! $membre->IdPAD !!}
                                </a>
                            </td>
                            <td>{!! $membre->NomComplet !!}</td>
                            <td nowrap>{!! $membre->Prenom !!}</td>
                            <td align="center">{!! $membre->DateNaissance !!}</td>
                            <td align="center">{!! $membre->Age !!}&nbsp;ans</td>
                            <td align="center">{!! $membre->Sexe !!}</td>
                            <td align="center">{!! $membre->Role !!}</td>
                            @if($mode=="show")
                            <td nowrap>
                                <a href="{!! url('allocataires/'.$membre->id) !!}" target="_blank" class="btn btn-sm  btn-warning">
                                    <span class='fas fa-eye'></span>
                                </a> 
                            </td>
                            @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    </div>
@else
    <div class="callout callout-secondary">
        @if(($allocataire->id_famille)&&($allocataire->age>=18))
            <h6 class="text-primary">Allocataire membre du foyer<br/>Les membres ne sont affichés que pour le titulaire ou le conjoint </h6>
        @else
            <h6 class="text-danger">Pour ajouter des membres ou enfants il faut lui associer un dossier famille</h6>
        @endif
    </div>
@endif

