

<!-- RESSOURCES -->
<div class="callout callout-danger">

    <div class="col-md-12">
        {!! html()->label("Ressources de l'allocataire",'',) !!}
        <table id="_table_ressources" class="table table-condensed table-stripped t">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Source</th>
                    <th>Date de Fin</th>
                    <th>Observations</th>
                    <th>Montant</th>
                    @if($mode=="show")
                        <th width='1px' >
                            <a href="{!! url('allocataires_add_ressources_pop/'.$allocataire->id) !!}" class="box_ressource fancybox.iframe">
                                <button class="btn btn-sm btn-success" value="Nouvelle ressource" type="button"><i class="fas fa-plus"></i></button>    
                            </a>  
                        </th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach($ressources as $ressource)
                    @php 
                        $fini=($ressource->DateFinUS<=date('Y-m-d') && ($ressource->DateFin)) ;
                        if(!isset($total)) $total=0; 
                        $style_montant="color:darkblue;font-weight:bold;";
                        if(!$fini) $total+=$ressource->montant; 
                        else $style_montant="color:grey;font-style:italic;";
                    @endphp
                    <tr>
                        <td>{{ $ressource->Type }}</td>
                        <td>{{ $ressource->source }}</td>
                        <td style="color:{{ $fini?'red':'black' }}">{{ $ressource->DateFin }}</td>
                        <td>{{ $ressource->observations }}</td>
                        <td  align="right" style="{{ $style_montant }}">{{ $ressource->montant }}</td>
                        @if($mode=="show")
                            <td >
                                <a href="{!! url('allocataires_show_ressources_pop/'.$ressource->id) !!}" class="fancybox.iframe box_ressource btn btn-sm  btn-warning">
                                    <span class='fas fa-eye'></span>
                                </a> 
                            </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
            <thead>
                <tr style="background-color:lightgrey">
                    <th colspan="4">TOTAL au {{ date('d/m/Y') }}</th>
                    <th style='text-align:right' >{{ isset($total)?$total:0 }}</th>
                    @if($mode=="show")
                    <th ></th>
                    @endif
                </tr>
            </thead>
        </table>
    </div>

    
    <div class="col-md-3 text-secondary">
        {!! html()->label( 'Montant Retraite CPSWF','montant_retraite_cpswf') !!}
        @if(App\Models\MyApp::hasSIPREDroit("montant_retraite"))
        <div class="input-group mb-3">
            {!! html()->text('montant_retraite_cpswf', $allocataire->MontantRetraiteCPSWF)->attributes(['disabled', 'class' => 'text-success text-right form-control']) !!}
            <div class="input-group-append">
                <span class="input-group-text ">CFP</span>
            </div>
        </div>
        @else
            <h6 class="text-info">Accès non accordé par la CPSWF</h6>
        @endif
    </div>

    <div class="col-md-3 text-secondary">
        {!! html()->label( 'Montant Allocations CPSWF','montant_allocations_cpswf') !!}
        @if(App\Models\MyApp::hasSIPREDroit("montant_alloc"))
        <div class="input-group mb-3">
            {!! html()->text('montant_allocations_cpswf', $allocataire->MontantAllocations)->attributes(['disabled', 'class' => 'text-success text-right form-control']) !!}
            <div class="input-group-append">
                <span class="input-group-text ">CFP</span>
            </div>
        </div>
        @else
            <h6 class="text-info">Accès non accordé par la CPSWF</h6>
        @endif
    </div>
</div>



