@extends('layouts.dash')

@section('title') Banques @stop

@section('subtitle_card',"")
@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3>Banques</h3>
        </div>
        <div class="card-body">
            @if($user->can("BQE_AJO") || $user->HasRole("ADMINISTRATEUR"))
                 <div class="row">
                    <a href="{{ url('banques/create') }}" class="btn btn-success">Ajouter un Banque</a>
                </div>
            @endif
            <table id="_table" class="table table-condensed table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Ville</th>
                        <th>Agence</th>
                        <th>Contact</th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($banques as $banque)
                    <tr>
                        <td>
                            <a href="./banques/{!! $banque->id !!}">
                            {!! $banque->nom !!}
                            </a>
                        </td>
                        <td>{!! $banque->ville !!}</td>
                        <td>{!! $banque->agence !!}</td>
                        <td>{!! $banque->contact !!}</td> 
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection


