@extends('layouts.dash')
@section('title') Enfants @stop
@section('title_card') Enfants @stop

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header bg-warning">
            <h2 class="card-title">{{ $title }}</h2>

        </div>
        <div class="card-body">
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th width='1px'>IdFamille</th>
                        <th >Nom</th>
                        <th width='1px'>Date de naissance</th>
                        <th width='1px'>Age</th>
                        <th width='1px'>Certificat</th>
                        <th >Parents</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Création</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($enfants as $enfant)
                        <tr>
                            <td>
                                <a class="btn bg-secondary"  href="{!! url('enfants/'.$enfant->id) !!}">
                                {!! $enfant->IdPAD !!}
                                </a>
                            </td>
                            <td>
                                @if($enfant->id_famille || $enfant->IdFamilleMembre || $enfant->IdPADFamilleResponsable)
                                    <a class="btn bg-primary" href="{!! url('familles/'.$enfant->id_famille) !!}">
                                        @if($enfant->id_famille)
                                            {!! $enfant->IdPADFamille !!}

                                        @elseif($enfant->IdFamilleMembre)
                                            {!! $enfant->IdFamilleMembre !!}

                                        @elseif($enfant->IdPADFamilleResponsable)
                                            {!! $enfant->IdPADFamilleResponsable !!}
                                        @endif

                                    </a>
                                @else
                                    <span class="badge badge-info right"> Aucun</span>
                                @endif
                            <td>
                                {!! $enfant->NomComplet !!}
                                @if ($enfant->statut_dossier!="ACT")
                                <span class="right badge badge-danger">Inactif</span>   
                                @endif                                
                            </td>
                            <td align="center">{!! $enfant->date_naissance !!}</td>
                            <td align="center">{!! $enfant->Age !!}</td>
                            <td align="center">{!! $enfant->certificat_enfant !!}</td>
                            <td>
                                @if($enfant->NomCompletParent1)
                                    <a href="{!! url('allocataires/'.$enfant->id_parent1) !!}" target="_blank">
                                        {!! $enfant->NomCompletParent1 !!}&nbsp;<small title="Titulaire du dossier Famille" class="text-warning"><i class="fas fa-user-check"></i></small>
                                    </a>
                                @endif
                                @if($enfant->NomCompletParent2)
                                    <br/>
                                    <a href="{!! url('allocataires/'.$enfant->id_parent2) !!}" target="_blank">{!! $enfant->NomCompletParent2 !!}</a>
                                @endif
                            </td>
                            <td align="center">{!! $enfant->statut !!}</td>
                            <td align="center" title="{!! $enfant->created_at !!}">{!! substr($enfant->created_at,0,10) !!}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection
