@extends('layouts.dash')
@section('title') Versements @stop
@section('title_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header bg-{{ App\Models\MyApp::COLOR_AIDES[$type_aide] }}">
            {!! $title !!}
        </div>
        <div class="card-body">
                <div class="">
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th >Allocataire</th>
                                <th >Statut</th>
                                <th >Sexe</th>
                                <th width='1%'>Naissance</th>
                                <th >Tel</th>
                                <th >Adresse</th>
                                <th >Ile</th>
                                <th >District</th>
                                <th >Village</th>
                                <th >Raison/Refus</th>
                                <th >QF</th>
                                <th width='1%'>Montant</th>
                                <th width='1%'>Total</th>
                                <th>Observations</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $nb_versements_nd=0; @endphp
                            @foreach ($versements_refus as $versement)
                                @php
                                    $nb_versements_nd+=(!$versement->mode_versement)?1:0;
                                @endphp
                                <tr>
                                    <td><a class="btn bg-info" href="{!! url('allocataires/'.$versement->id_allocataire) !!}" >
                                            {!! $versement->AllocataireIdPAD !!}
                                        </a>
                                    </td>
                                    <td><b>{!! $versement->destinataire_nom." ".$versement->destinataire_prenom !!}</b></td>
                                    <td>{!! $versement->destinataire_statut !!}</td>
                                    <td>{!! $versement->EtatCivil !!}</td>
                                    <td>{!! $versement->AllocataireDateNaissance !!}</td>
                                    <td>{!! $versement->Telephone !!}</td>
                                    <td>{!! $versement->Adresse !!}</td>
                                    <td>{!! $versement->ile !!}</td>
                                    <td>{!! $versement->district !!}</td>
                                    <td>{!! $versement->village !!}</td>
                                    <td>{!! $versement->RaisonLibelle !!}</td>
                                    <td align="right" >{!! $versement->qf !!}</td>
                                    <td align="right" class="text-primary" nowrap>
                                        <b>{!! $versement->montant !!}</b>
                                    </td>
                                    <td align="right" class="text-success" ><b>{!! $versement->montant_r+$versement->montant !!}</b></td>
                                    <td>{!! $versement->observations !!}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

        </div>
    </div>
@endsection


@section('scripts0')
<script>
    $(function () {

    })
    </script>
    @include('forms.scripts_datatable_btn')
@endsection


