@extends('layouts.dash')
@section('title') Génération @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    <div class="card card-primary">
        <div class="card-header">
            <h3 class="card-title">{!! $title !!}</h3>
        </div>
        <div align="center" class="card-body">
            {{ html()->form('POST', url('versements_generation_def_'.strtolower($type_aide)))->open() }}
            @if(!isset($num_def))
                <div class="h5 col-md-12 bg-warning alert">
                    <div class="row" >
                        <div class="col-md-2"> </div>
                        <div class="col-md-8" align="center">
                            Cette opération va permettre de Transférer les versements en-cours des {{ $nb_versements }} lignes <br/><b>{{ App\Models\MyApp::TYPES_AIDES[$type_aide] }} </b><br/>dans les versements définitifs.
                        </div>
                    </div>
                    <div class="row p-3">
                        <div class="col-md-12" align="center">Le numéro attribué à ce versement sera le :</div>
                    </div>
                    <div class="row p-3">
                        <div class="col-md-5"> </div>
                        <div class="col-md-2"> 
                            {!! html()->text('num_imp', str_pad($num_imp, 4, "0", STR_PAD_LEFT))->attributes(['readonly', 'class' => 'form-control',
                                    'style'=>'font-weight:bold;font-size:23px;text-align:center']) !!}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3"> </div>
                        <div class="col-md-6"> Cliquez sur le bouton ci-dessous pour générer ce fichier.</div>
                    </div>
                </div>
                <div class="row col-md-12">
                    <div class="col-md-3"> </div>
                    <div class="col-md-6"> 
                        {!! html()->button('Génération définitive du versement des '.App\Models\MyApp::TYPES_AIDES[$type_aide])
                            ->type('submit')->attributes(['class' => 'btn btn-danger','style'=>'font-size:24px']) !!}
                    </div>
                </div>
            @else
                <div class="row col-md-12">
                    @if(count($errors)>0)
                        <div class="h5 col-md-12 bg-danger success">
                            @foreach ($errors as $error)
                                <div class='m-2'>{!! $error !!}</div><br/>
                            @endforeach
                        </div>
                    @else
                        <div class="h5 col-md-12 bg-warning success">
                            <div class="row" >
                                <div class="col-md-2"> </div>
                                <div class="col-md-8" align="center">
                                    Le transfert est terminé.<br/>
                                    Les {!! $nb_versement !!} versements pour les <br/><b>{!! App\Models\MyApp::TYPES_AIDES[$type_aide] !!} </b><br/> en préparation ont été transférés vers les versements définitifs.                  
                                    <br/><br/>
                                    Sous le numéro de bordereau :
                                    <span class="h4"><b>{!! $num_def !!}</b></span>
                                    <br/>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            @endif 
            {{ html()->form()->close() }}
        </div>
    </div>
@stop




