@extends('layouts.dash')
@section('title') Validation des versements @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    <div class="card card-primary">
        <div class="card-header">
            <h3 class="card-title">{!! $title !!}</h3>
        </div>
        <div align="center" class="card-body">
            {{ html()->form('POST', url('versements_generation_def/'.$type_aide))->open() }}
            @if(!isset($num_def))
            <div class="h5 col-md-12 bg-warning alert">
                <div class="row" >
                    <div class="col-md-2"> </div>
                    <div class="col-md-8" align="center">
                    Cette opération va permettre de Transférer les versements en-cours des <b>{{ App\Models\MyApp::TYPES_AIDES[$type_aide] }} </b>dans les versements définitifs.
                    </div>
                </div>
                <div class="row p-3">
                     <div class="col-md-12" align="center">Le numéro attribué à ce versement sera le :</div>
                </div>
                <div class="row p-3">
                    <div class="col-md-5"> </div>
                    <div class="col-md-2"> 
                        {!! html()->text('num_imp', $num_imp)->placeholder("CODE POSTAL")->attributes(['readonly', 'class' => 'form-control','style'=>'font-weight:bold;font-size:23px;text-align:center']) !!}
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3"> </div>
                    <div class="col-md-6"> 
                        Cliquez sur le bouton ci-dessous pour générer ce fichier.
                    </div>
                </div>
            </div>
            <div class="row col-md-12">
                    <div class="col-md-3"> </div>
                    <div class="col-md-6"> 
                    {!! html()->button('Génération définitive du versement de : '.{{ App\Models\MyApp::TYPES_AIDES[$type_aide] }})
                        ->type('submit')->attributes(['class' => 'btn btn-danger','style'=>'font-size:24px']) !!}
                    </div>
                </div>
            </div>
            @else
            <div class="row col-md-12">
                @if(count($errors)>0)
                    @foreach ($errors as $error)
                        <div class='bg-danger alert'>{!! $error !!}</div>
                    @endforeach 
                @else
                    <div class="h5 col-md-12 bg-warning success">
                        <div class="row" >
                            <div class="col-md-2"> </div>
                            <div class="col-md-8" align="center">
                                    Le transfert est terminé. 
                                    Les {!! $nb_versements_b !!} versements pour <b>{{ App\Models\MyApp::TYPES_AIDES[$type_aide] }} </b> en-cours ont été transférés vers les versements définitifs.                  
                                    <br/><br/>
                                    Sous le numéro de bordereau :
                                    <span class="h4"><b>{!! $num_imp !!}</b></span>
                            </div>
                        </div>
                    </div>
                @endif
            @endif 
            {{ html()->form()->close() }}
        </div>
    </div>
@stop
