@extends('layouts.dash')
@section('title') Validation des versements @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">{!! "Génération du versement" !!}</h3>
        </div>
        <div class="card-body">
            {{ html()->form('POST', url('versements_prepa_validation_'.strtolower($type_aide)))->open() }}
            <div align="center"  class="h5 col-md-12 text-normal">
                Cette opération va permettre de préparer la liste des allocataires pour permettre la validation définitivement les versements .
                <br/></b>
                Elle concerne <b>{{ $nb_versements }}</b> allocataires pour les montants cummulées suivants :<br/><br/>
            </div>
            <div class="row col-md-12 offset-md-3">
                
                <div class="col-md-6" align="center">
                    <table class="table">
                        <thead>
                            <tr class="bg-secondary">
                                <th>Ile</th>
                                <th>NbAlloc</th>
                                <th>Rappels</th>
                                <th>Montant</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach(App\Models\MyApp::ILES as $key=>$ile)
                            <tr>
                                <td>{{ $ile }}</td>
                                <td>{{ $t_stat[$key]["nb"] }}</td>
                                <td align="right">{{ $t_stat[$key]["montant_rappel"] }}</td>
                                <td align="right">{{ $t_stat[$key]["montant"] }}</td>
                                <td align="right">{{ $t_stat[$key]["total"] }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                        <tfoot>
                            <tr align="right">
                                <th>{{ "" }}</th>
                                <th >{{ $t_stat_total["nb"] }}</th>
                                <th >{{ $t_stat_total["total_montant_rappel"] }}</th>
                                <th >{{ $t_stat_total["total_montant"] }}</th>
                                <th >{{ $t_stat_total["total"] }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="row col-md-12 offset-md-3">
                <div class="col-md-6" align="center">
                    <div class="form-group">
                        {!! html()->button('Générer le brouillon des versements')->type('submit')
                            ->attributes(['class' => 'btn btn-sm btn-danger','style'=>'font-size:18px']) !!}
                    </div>
                </div>
            </div>
            {{ html()->form()->close() }}
        </div>
    </div>
@stop
