<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BotManController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/logout', 'App\Http\Controllers\Auth\LoginController@logout');

Auth::routes();

Route::get('change_profil',array('as' => 'change_profile' , 'uses' => 'App\Http\Controllers\Auth\ChangeProfilController@newprofil'));
Route::put('change_profil',array('as' => 'change_profile' , 'uses' => 'App\Http\Controllers\Auth\ChangeProfilController@changeprofil'));

Route::get('change_pwd', array('as' => 'change_pwd', 'uses'=>'App\Http\Controllers\UsersController@resetpassword')); // Liste formulaires
Route::post('pwd_reset', array('as' => 'pwd_reset', 'uses'=>'App\Http\Controllers\UsersController@postReset')); // Liste formulaires


Route::get('/', function () {
    return view('welcome');
});

Route::get('/home', 'App\Http\Controllers\HomeController@index')->name('home');
Route::get('/home/{type}', 'App\Http\Controllers\HomeController@index')->name('home');
//Route::get('/home/analyses', 'App\Http\Controllers\HomeController@index')->name('home');


/* ***** ACCES / USERS / ROLES / PERMISSIONS ***** */
Route::resource('/users', 'App\Http\Controllers\UsersController');
Route::delete('/users/delete/{id}','App\Http\Controllers\UsersController@destroy');
Route::resource('/roles', 'App\Http\Controllers\RolesController');
Route::get('/roles_det', 'App\Http\Controllers\RolesController@index_det');
Route::resource('/permissions', 'App\Http\Controllers\PermissionsController');
Route::get('/roles_tableau', 'App\Http\Controllers\RolesController@index_tableau');
Route::get('/role_tableau_filtre/{id}', 'App\Http\Controllers\RolesController@index_tableau');

/* ********* Mises à jour Show ********** */
Route::get('/show_maj/{type}/{id}', 'App\Http\Controllers\RevisionsController@index');
Route::get('/show_maj_comptes/{id_alloc}', 'App\Http\Controllers\RevisionsController@index_comptes');

/* ********* FAMILLES ********** */
Route::resource('/familles', 'App\Http\Controllers\FamillesController');
Route::get('/familles_add_dossier/{id}', 'App\Http\Controllers\FamillesController@create_dossier');
Route::get('/familles_filtre/{ile}/{aide}', 'App\Http\Controllers\FamillesController@index');
Route::get('/famille_delete/{id}', 'App\Http\Controllers\FamillesController@destroy');
Route::get('famille_replace_titulaire/{id_famille}', 'App\Http\Controllers\FamillesController@replaceTitulaire');
Route::post('famille_replace_titulaire/{id_famille}', 'App\Http\Controllers\FamillesController@storeNewTitulaire');

//Enfant
Route::get('famille_add_enfant/{id_famille}', 'App\Http\Controllers\FamillesController@addEnfant');
Route::post('famille_add_enfant/{id_famille}', 'App\Http\Controllers\FamillesController@storeEnfant');
Route::get('famille_remove_enfant/{id_famille}/{id_enfant}', 'App\Http\Controllers\FamillesController@removeEnfant');
Route::get('auto_famille_enfant', 'App\Http\Controllers\FamillesController@autocomplete_enfant');

//Membre
Route::get('famille_add_membre/{id_famille}', 'App\Http\Controllers\FamillesController@addMembre');
Route::post('famille_add_membre/{id_famille}', 'App\Http\Controllers\FamillesController@storeMembre');
Route::get('famille_remove_membre/{id_famille}/{id_enfant}', 'App\Http\Controllers\FamillesController@removeMembre');
Route::get('auto_famille_membre', 'App\Http\Controllers\FamillesController@autocomplete_membre');
Route::get('famille_swap_titulaire/{id_famille}', 'App\Http\Controllers\FamillesController@swap_titulaire');

//Membre sans statut
Route::get('famille_remove_autre/{id_famille}/{id_autre}', 'App\Http\Controllers\FamillesController@removeAutre');


/* ********* allocataireS ********** */
//Route::get('/allocataire_add/{type}', 'App\Http\Controllers\AllocatairesController@create');
//Route::get('/allocataire_edit/{id}/{type}', 'App\Http\Controllers\AllocatairesController@edit');
//Route::get('/allocataire_liste/{type}', 'App\Http\Controllers\AllocatairesController@index');
//Route::get('/allocataire_show/{id}/{type}', 'App\Http\Controllers\AllocatairesController@show');
Route::resource('/allocataires', 'App\Http\Controllers\AllocatairesController');
Route::get('/allocataires_light/{ile?}/{aide?}/{actif?}', 'App\Http\Controllers\AllocatairesController@index_light');

Route::get('/allocataires_filtre/{ile}/{aide}/{actif}', 'App\Http\Controllers\AllocatairesController@index');


//Enfants
Route::post('allocataire_add_select_enfant', 'App\Http\Controllers\AllocatairesController@add_enfant');
Route::get('allocataire_add_enfant/{allocataire_id}', 'App\Http\Controllers\AllocatairesEnfantsController@create_pop');
Route::get('allocataire_show_enfant/{id}/{allocataire_id}', 'App\Http\Controllers\AllocatairesEnfantsController@show');
Route::get('allocataire_edit_enfant/{id}/{allocataire_id}', 'App\Http\Controllers\AllocatairesEnfantsController@edit');
Route::get('allocataire_delete_enfant/{id}/{allocataire_id}/{type}', 'App\Http\Controllers\AllocatairesEnfantsController@destroy');
Route::resource('/enfants', 'App\Http\Controllers\EnfantsController');

/* ********* ENFANTS ********** */
Route::resource('/enfants', 'App\Http\Controllers\EnfantsController');

//Membres
Route::post('allocataire_add_select_membre', 'App\Http\Controllers\AllocatairesController@add_membre');
Route::get('allocataire_allocataire_add_membre/{allocataire_id}', 'App\Http\Controllers\AllocatairesMembresController@create_pop');
Route::get('allocataire_add_membre/{allocataire_id}', 'App\Http\Controllers\AllocatairesMembresController@create_pop');

//Ressources
Route::resource('allocataires_ressources', 'App\Http\Controllers\AllocatairesRessourcesController');
Route::get('allocataires_show_ressources_pop/{id}', 'App\Http\Controllers\AllocatairesRessourcesController@show_pop');
Route::get('allocataires_add_ressources_pop/{id_allocataire}', 'App\Http\Controllers\AllocatairesRessourcesController@create_pop');
Route::get('allocataires_maj_ressources_pop/{id}', 'App\Http\Controllers\AllocatairesRessourcesController@edit_pop');
Route::get('allocataires_delete_ressources_pop/{id}', 'App\Http\Controllers\AllocatairesRessourcesController@delete_pop');

//Documents
Route::post('allocataires_add_documents', 'App\Http\Controllers\DocumentsController@store');
Route::put('allocataires_update_documents/{id}', 'App\Http\Controllers\DocumentsController@update');
Route::resource('allocataires_documents', 'App\Http\Controllers\DocumentsController');

Route::get('allocataires_show_documents_pop/{id}', 'App\Http\Controllers\DocumentsController@show_pop');
Route::get('allocataires_add_documents_pop/{id_allocataire}', 'App\Http\Controllers\DocumentsController@create_pop');
Route::get('allocataires_maj_documents_pop/{id}', 'App\Http\Controllers\DocumentsController@edit_pop');
Route::get('allocataires_delete_documents_pop/{id}', 'App\Http\Controllers\DocumentsController@delete_pop');

//Route::get('ressources_pop/{id}', 'App\Http\Controllers\AllocatairesRessourcesController@edit_pop');
Route::get('auto_allocataire', 'App\Http\Controllers\AllocatairesRessourcesController@autocomplete_allocataire');

//Route::get('allocataire_delete_ressources/{id}/{allocataire_id}', 'App\Http\Controllers\AllocatairesRessourcesController@destroy');





//Conjoint
Route::get('auto_conjoint', 'App\Http\Controllers\AllocatairesController@autocomplete_conjoint');
//Parent
Route::get('auto_parent', 'App\Http\Controllers\AllocatairesController@autocomplete_parent');

//Enfant
Route::get('auto_alloc_enfant', 'App\Http\Controllers\AllocatairesController@autocomplete_enfant');

//Membre
Route::get('auto_alloc_membre', 'App\Http\Controllers\AllocatairesController@autocomplete_membre');

//Procuration
Route::get('auto_procuration', 'App\Http\Controllers\AllocatairesController@autocomplete_procuration');

//Home : Famille ou alloctaire
Route::get('auto_alloc_home', 'App\Http\Controllers\AllocatairesController@autocomplete_home');




/* ********* AIDES ********** */
Route::get('aides_aae/{ile?}', 'App\Http\Controllers\AidesController@index_aae');
Route::get('set_statut_aae', 'App\Http\Controllers\AidesController@set_statut_aae');
Route::post('set_statut_aae', 'App\Http\Controllers\AidesController@change_statut');
//PAN
Route::get('aides_pan/{ile?}', 'App\Http\Controllers\AidesController@index_pan');
//Filet CSR
Route::get('aides_csr/{ile?}', 'App\Http\Controllers\AidesController@index_csr');
//Filet Social
Route::get('aides_fso/{ile?}', 'App\Http\Controllers\AidesController@index_fso');
Route::get('set_statut_fso', 'App\Http\Controllers\AidesController@set_statut_fso');
Route::post('set_statut_fso', 'App\Http\Controllers\AidesController@change_statut');
Route::get('remove_aide_fso', 'App\Http\Controllers\AidesController@remove_aide_fso');
//Filet AGD
Route::get('aides_agd/{ile?}', 'App\Http\Controllers\AidesController@index_agd');
//Filet APH
Route::get('aides_aph/{ile?}', 'App\Http\Controllers\AidesController@index_aph');

//Refus FSO
Route::get('set_refus_fso/{filtre?}', 'App\Http\Controllers\AidesController@set_refus_fso');
Route::post('set_refus_fso', 'App\Http\Controllers\AidesController@change_refus_fso');


/* ********* VERSEMENTS ********** */
/* VersementsPrepaController */
//Ressources

Route::get('versements_ressources_maj', 'App\Http\Controllers\VersementsRessourcesController@maj_ressources');


Route::get('versements_ressources', 'App\Http\Controllers\VersementsRessourcesController@index');


//aae
Route::get('versements_prepa_aae/{ile?}', 'App\Http\Controllers\VersementsPrepaController@index_aae');
Route::get('versements_prepa_validation_aae', 'App\Http\Controllers\VersementsPrepaController@validation_prepa_aae');
Route::post('versements_prepa_validation_aae', 'App\Http\Controllers\VersementsPrepaController@generation_aae');
Route::get('versements_generation_def_aae', 'App\Http\Controllers\VersementsPrepaController@confirm_generation_def_aae');
Route::post('versements_generation_def_aae', 'App\Http\Controllers\VersementsPrepaController@generation_def_aae');


//pan
Route::get('versements_prepa_pan/{ile?}', 'App\Http\Controllers\VersementsPrepaController@index_pan');
Route::get('versements_prepa_validation_pan', 'App\Http\Controllers\VersementsPrepaController@validation_prepa_pan');
Route::post('versements_prepa_validation_pan', 'App\Http\Controllers\VersementsPrepaController@generation_pan');
Route::get('versements_generation_def_pan', 'App\Http\Controllers\VersementsPrepaController@confirm_generation_def_pan');
Route::post('versements_generation_def_pan', 'App\Http\Controllers\VersementsPrepaController@generation_def_pan');

//CSR
Route::get('versements_prepa_csr/{ile?}', 'App\Http\Controllers\VersementsPrepaController@index_csr');
Route::get('versements_prepa_validation_csr', 'App\Http\Controllers\VersementsPrepaController@validation_prepa_csr');
Route::post('versements_prepa_validation_csr', 'App\Http\Controllers\VersementsPrepaController@generation_csr');
Route::get('versements_generation_def_csr', 'App\Http\Controllers\VersementsPrepaController@confirm_generation_def_csr');
Route::post('versements_generation_def_csr', 'App\Http\Controllers\VersementsPrepaController@generation_def_csr');

//fso
Route::get('versements_prepa_fso/{ile?}/{filtre?}', 'App\Http\Controllers\VersementsPrepaController@index_fso');
Route::get('versements_prepa_validation_fso', 'App\Http\Controllers\VersementsPrepaController@validation_prepa_fso');
Route::post('versements_prepa_validation_fso', 'App\Http\Controllers\VersementsPrepaController@generation_fso');
Route::get('versements_generation_def_fso', 'App\Http\Controllers\VersementsPrepaController@confirm_generation_def_fso');
Route::post('versements_generation_def_fso', 'App\Http\Controllers\VersementsPrepaController@generation_def_fso');

//agd
Route::get('versements_prepa_agd/{ile?}', 'App\Http\Controllers\VersementsPrepaController@index_agd');
Route::get('versements_prepa_validation_agd', 'App\Http\Controllers\VersementsPrepaController@validation_prepa_agd');
Route::post('versements_prepa_validation_agd', 'App\Http\Controllers\VersementsPrepaController@generation_agd');
Route::get('versements_generation_def_agd', 'App\Http\Controllers\VersementsPrepaController@confirm_generation_def_agd');
Route::post('versements_generation_def_agd', 'App\Http\Controllers\VersementsPrepaController@generation_def_agd');


//aph
Route::get('versements_prepa_aph/{ile?}', 'App\Http\Controllers\VersementsPrepaController@index_aph');
Route::get('versements_prepa_validation_aph', 'App\Http\Controllers\VersementsPrepaController@validation_prepa_aph');
Route::post('versements_prepa_validation_aph', 'App\Http\Controllers\VersementsPrepaController@generation_aph');
Route::get('versements_generation_def_aph', 'App\Http\Controllers\VersementsPrepaController@confirm_generation_def_aph');
Route::post('versements_generation_def_aph', 'App\Http\Controllers\VersementsPrepaController@generation_def_aph');

/* VersementsController */
Route::get('versements', 'App\Http\Controllers\VersementsController@index');
Route::get('versements_aae/{num_imp?}', 'App\Http\Controllers\VersementsController@index_aae');
Route::get('versements_pan/{num_imp?}', 'App\Http\Controllers\VersementsController@index_pan');
Route::get('versements_csr/{num_imp?}', 'App\Http\Controllers\VersementsController@index_csr');
Route::get('versements_fso/{num_imp?}', 'App\Http\Controllers\VersementsController@index_fso');
Route::get('versements_fso_refus/{numimp?}', 'App\Http\Controllers\VersementsController@index_fso_refus');
Route::get('versements_agd/{num_imp?}', 'App\Http\Controllers\VersementsController@index_agd');
Route::get('versements_aph/{num_imp?}', 'App\Http\Controllers\VersementsController@index_aph');


//Suppressions
Route::get('versements_delete/{type_aide}/{num_imp}', 'App\Http\Controllers\VersementsController@delete');


/* versements_print_ */
Route::get('versements_print_csr/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsController@imprimer_csr');
Route::get('versements_print_aae/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsController@imprimer_aae');
Route::get('versements_print_pan/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsController@imprimer_pan');
Route::get('versements_print_fso/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsController@imprimer_fso');
Route::get('versements_print_agd/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsController@imprimer_agd');
Route::get('versements_print_aph/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsController@imprimer_aph');

Route::get('versements_print_liste_csr/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeController@imprimer_csr');
Route::get('versements_print_liste_aae/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeController@imprimer_aae');
Route::get('versements_print_liste_pan/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeController@imprimer_pan');
Route::get('versements_print_liste_fso/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeController@imprimer_fso');
Route::get('versements_print_liste_agd/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeController@imprimer_agd');
Route::get('versements_print_liste_aph/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeController@imprimer_aph');

//Liste DFIP
Route::get('versements_print_dfip_csr/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_dfip_csr');
Route::get('versements_print_dfip_aae/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_dfip_aae');
Route::get('versements_print_dfip_pan/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_dfip_pan');
Route::get('versements_print_dfip_fso/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_dfip_fso');
Route::get('versements_print_dfip_agd/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_dfip_agd');
Route::get('versements_print_dfip_aph/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_dfip_aph');

//LIste AUTRES
Route::get('versements_print_vrmt_csr/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_vrmt_csr');
Route::get('versements_print_vrmt_aae/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_vrmt_aae');
Route::get('versements_print_vrmt_pan/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_vrmt_pan');
Route::get('versements_print_vrmt_fso/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_vrmt_fso');
Route::get('versements_print_vrmt_agd/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_vrmt_agd');
Route::get('versements_print_vrmt_aph/{num_imp}', 'App\Http\Controllers\Editions\EditionsVersementsListeDfipController@imprimer_vrmt_aph');

//LIste Numeraires
Route::get('versements_print_num_csr/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeNumeraireController@imprimer_csr');
Route::get('versements_print_num_aae/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeNumeraireController@imprimer_aae');
Route::get('versements_print_num_pan/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeNumeraireController@imprimer_pan');
Route::get('versements_print_num_fso/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeNumeraireController@imprimer_fso');
Route::get('versements_print_num_agd/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeNumeraireController@imprimer_agd');
Route::get('versements_print_num_aph/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeNumeraireController@imprimer_aph');

//Emargement
Route::get('versements_print_emargement_csr/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeEmargementController@imprimer_csr');
Route::get('versements_print_emargement_aae/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeEmargementController@imprimer_aae');
Route::get('versements_print_emargement_pan/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeEmargementController@imprimer_pan');
Route::get('versements_print_emargement_fso/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeEmargementController@imprimer_fso');
Route::get('versements_print_emargement_agd/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeEmargementController@imprimer_agd');
Route::get('versements_print_emargement_aph/{num_imp}/{ile}', 'App\Http\Controllers\Editions\EditionsVersementsListeEmargementController@imprimer_aph');

//CERTIFICATS
Route::get('maj_certificats_etrangers', 'App\Http\Controllers\CertificatsController@index_certificats_etrangers');
Route::get('maj_certificats', 'App\Http\Controllers\CertificatsController@index_certificats');
Route::post('maj_certificats', 'App\Http\Controllers\CertificatsController@maj_certificats');
Route::post('maj_certificats_etrangers', 'App\Http\Controllers\CertificatsController@maj_certificats_etrangers');
Route::get('maj_certificats_info/{etrangers?}', 'App\Http\Controllers\CertificatsController@info_certificats');

//ATTESTATIONS
Route::get('attestation_pmt/{type_aide}/{id}', 'App\Http\Controllers\Editions\EditionsAttestationsPaiementController@imprime');


/* Export */
Route::get('versements_export_csr/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_csr');
Route::post('versements_export_csr/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_csr');
Route::get('versements_export_aae/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_aae');
Route::post('versements_export_aae/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_aae');
Route::get('versements_export_pan/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_pan');
Route::post('versements_export_pan/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_pan');
Route::get('versements_export_fso/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fso');
Route::post('versements_export_fso/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fso');
Route::get('versements_export_agd/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_agd');
Route::post('versements_export_agd/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_agd');
Route::get('versements_export_aph/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_aph');
Route::post('versements_export_aph/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_aph');

/* CPSWF */
Route::get('cpswf_benef', 'App\Http\Controllers\CPSWFController@index');
Route::get('cpswf_benef/{id}', 'App\Http\Controllers\CPSWFController@show');


/* ********* LOGS ********** */
Route::get('/log_user/{usr_id}', 'App\Http\Controllers\LogsController@index_user');


Route::get('parametres', 'App\Http\Controllers\ParametresController@index');
Route::get('parametres/{categorie}', 'App\Http\Controllers\ParametresController@index');
Route::PUT('categorie', 'App\Http\Controllers\ParametresController@update');


/* ********* Villages Districts Données de base ********** */
Route::resource('villages', 'App\Http\Controllers\VillagesController');
Route::resource('districts', 'App\Http\Controllers\DistrictsController');


/* ********* IMPORTATIONS ********** */
Route::get('importation_aae', 'App\Http\Controllers\ImportationsController@index_aae');
Route::post('importation_beneficiaires', 'App\Http\Controllers\ImportationsController@import');
Route::get('importation_csr', 'App\Http\Controllers\ImportationsController@index_csr');
Route::post('importation_beneficiaires', 'App\Http\Controllers\ImportationsController@import');

/* ********* BANQUES ********** */
Route::resource('banques', 'App\Http\Controllers\BanquesController');


/* ********* STATS ********** */
Route::get('stats_tdb_aae/{mois?}/{onglet?}', 'App\Http\Controllers\StatsController@index_aae');
Route::get('stats_tdb_pan/{mois?}/{onglet?}', 'App\Http\Controllers\StatsController@index_pan');
Route::get('stats_tdb_csr/{mois?}/{onglet?}', 'App\Http\Controllers\StatsController@index_csr');
Route::get('stats_tdb_fso/{mois?}/{onglet?}', 'App\Http\Controllers\StatsController@index_fso');
Route::get('stats_tdb_aph/{mois?}/{onglet?}', 'App\Http\Controllers\StatsController@index_aph');
Route::get('stats_tdb_agd/{mois?}/{onglet?}', 'App\Http\Controllers\StatsController@index_agd');

Route::get('stats_graph_aae/{annee?}', 'App\Http\Controllers\StatsController@index_graph_aae');
Route::get('stats_graph_pan/{annee?}', 'App\Http\Controllers\StatsController@index_graph_pan');
Route::get('stats_graph_fso/{annee?}', 'App\Http\Controllers\StatsController@index_graph_fso');
Route::get('stats_graph_csr/{annee?}', 'App\Http\Controllers\StatsController@index_graph_csr');
Route::get('stats_graph_aph/{annee?}', 'App\Http\Controllers\StatsController@index_graph_aph');
Route::get('stats_graph_agd/{annee?}', 'App\Http\Controllers\StatsController@index_graph_agd');

/* ********* PARAMETRES ********** */
/* ZBASES */
Route::resource('zbases', 'App\Http\Controllers\ZBasesController');
Route::get('zbases_filtre/{base?}', 'App\Http\Controllers\ZBasesController@index');
Route::get('zbases_create/{base?}', 'App\Http\Controllers\ZBasesController@create_base');
/* ********* Autres ********** */
Route::get('parametres_taux', 'App\Http\Controllers\ParametresController@index_taux');
Route::get('parametres_editions', 'App\Http\Controllers\ParametresController@index_editions');
Route::get('parametres_emails', 'App\Http\Controllers\ParametresController@index_emails');
Route::get('parametres_divers', 'App\Http\Controllers\ParametresController@index_divers');
Route::post('postParam', 'App\Http\Controllers\ParametresController@submitPost')->name('postParam');
