
<?php $__env->startSection('title'); ?> Allocataires <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Allocataires Filet Social <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>


    <div class="card">
        <div class="card-header bg-<?php echo e(App\Models\MyApp::COLOR_AIDES[$type_aide]); ?>">
            <h2 class="card-title">Liste des allocataire - <?php echo e($title); ?></h2>
            <div class="card-tools ml-auto">
                <a href="<?php echo e(url('remove_aide_fso')); ?>" onclick="if(!confirm('Voulez vous vraiment supprimer cette aide pour la sélection ?')) return false;" class="ml-auto btn btn-sm bg-purple"  >
                    <?php echo e("Enlever l'aide à tous les bénéficiaires"); ?>

                </a>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-2'>
                    <?php echo html()->label('Ile','select_ile'); ?>

                    <?php echo html()->select('select_ile',App\Models\MyApp::ILES,isset($ile)?$ile:"")->placeholder('Toutes')->attributes(['class' => 'form-control','id' => 'select_ile']); ?>

                </div>
            </div>
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th width='1px'>Dossier<br/>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th >Village</th>
                        <th width='1px'>Naissance</th>
                        <th width='1px'>Prés/Abs</th>
                        <th width='1px'>Age</th>
                        <th width='10%'>Banque/ModePmt</th>
                        <th >Conjoint</th>
                        <th width='1px'>NbPersonnes</th>
                        <th width='1px'>Ressources</th>
                        <th width='1px'>QF</th>
                        <th width='1px'>Refus</th>
                        <th width='1px'>Montant</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Mise à jour</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $allocataires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocataire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <a class="btn bg-secondary" href="<?php echo url('allocataires/'.$allocataire->id); ?>"><?php echo $allocataire->IdPAD; ?></a>
                            </td>
                            <td>
                                <?php if($allocataire->id_famille): ?>
                                    <a class="btn bg-primary" href="<?php echo url('familles/'.$allocataire->id_famille); ?>"><?php echo $allocataire->IdPADFamille; ?></a>
                                <?php else: ?>
                                    <span class="badge badge-info right"> Aucun</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $allocataire->IdCPSWFPAD; ?></td>
                            <td><?php echo $allocataire->nom_complet2; ?>

                                <?php if($allocataire->statut_dossier!="ACT"): ?>
                                    <span class="right badge badge-danger">Inactif</span>    
                                <?php endif; ?>
                            </td>
                            <td><?php echo $allocataire->VillageNom; ?></td>
                            <td align="center"><?php echo $allocataire->date_naissance; ?></td>
                            <td align="center"><?php echo $allocataire->getSituationWF(); ?></td>
                            <td align="center"><?php echo $allocataire->Age; ?></td>
                            <td>
                                <?php if($allocataire->mode_versement=="NUM"): ?>
                                    <span class="badge badge-warning right">NUMERAIRE</span>
                                <?php endif; ?>
                                <?php if($allocataire->mode_versement=="VIR"): ?>
                                    <?php echo $allocataire->NomBanque; ?>

                                <?php endif; ?>
                                <?php if(!$allocataire->mode_versement): ?>
                                    <span class="badge badge-danger right">AUCUN</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $allocataire->ConjointNomComplet; ?></td>
                            <td align="right"><?php echo $allocataire->FamilleNbPersonnes; ?></td>
                            <td align="right"><?php echo $allocataire->FamilleMontantRessources; ?></td>
                            <td align="right"><?php echo $allocataire->QF; ?></td>
                            <td align="left"><?php echo $allocataire->RaisonLibelle; ?></td>
                            <td align="right"><?php echo $allocataire->CalculMontantFSO; ?></td>
                            <td align="center"><?php echo $allocataire->statut; ?></td>
                            <td align="center" title="Création le <?php echo $allocataire->CreatedAt; ?>"><?php echo $allocataire->UpdatedAt; ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make("aides.scripts_aides", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal_test/resources/views/aides/index_fso.blade.php ENDPATH**/ ?>