
<?php $__env->startSection('title'); ?> Allocataires <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Allocataires <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>


    <div class="card">
        <div class="card-header bg-<?php echo e(App\Models\MyApp::COLOR_AIDES[$type_aide]); ?>">
            <h2 class="card-title">Liste des allocataire - <?php echo e($title); ?></h2>
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-2'>
                    <?php echo html()->label('Ile','select_ile'); ?>

                    <?php echo html()->select('select_ile',App\Models\MyApp::ILES,isset($ile)?$ile:"")->placeholder('Toutes')->attributes(['class' => 'form-control','id' => 'select_ile']); ?>

                </div>
            </div>
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th width='1px'>Dossier<br/>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th width='1px'>Date de naissance</th>
                        <th width='1px'>Prés/Abs</th>
                        <th >Conjoint</th>
                        <th width='1px'>NbEnfants</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Création</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $allocataires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocataire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td  >
                                <a class="btn bg-secondary" href="<?php echo url('allocataires/'.$allocataire->id); ?>"><?php echo $allocataire->IdPAD; ?></a>
                                <?php if($allocataire->controle): ?><br\>
                                    <span title="A Contrôler" class="right badge badge-danger">CTL</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($allocataire->id_famille): ?>
                                    <a class="btn bg-primary" href="<?php echo url('familles/'.$allocataire->id_famille); ?>"><?php echo $allocataire->IdPADFamille; ?></a>
                                <?php else: ?>
                                    <span class="badge badge-info right"> Aucun</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $allocataire->IdCPSWFPAD; ?></td>
                            <td><?php echo $allocataire->nom_complet2; ?>

                                <?php if($allocataire->statut_dossier!="ACT"): ?>
                                    <span class="right badge badge-danger">Inactif</span>    
                                <?php endif; ?>
                            </td>
                            <td align="center"><?php echo $allocataire->date_naissance; ?></td>
                            <td align="center"><?php echo $allocataire->getSituationWF(); ?></td>
                            <td><?php echo $allocataire->ConjointNomComplet; ?></td>
                            <td align="center"><?php echo $allocataire->NbEnfants; ?></td>
                            <td align="center"><?php echo $allocataire->statut; ?></td>
                            <td align="center" title="<?php echo $allocataire->created_at; ?>"><?php echo substr($allocataire->created_at,0,10); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make("aides.scripts_aides", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal_test/resources/views/aides/index_pan.blade.php ENDPATH**/ ?>