<div class="callout callout-primary">
    <!-- CONJOINT -->
    <div class="form-group row">
        <div class="col-md-6">
            <?php echo html()->label( 'Conjoint '.($partenaire && $partenaire->isTitulaire?'Titulaire':'Non Titulaire'),'nom_conjoint'); ?>

            <?php echo html()->hidden('id_conjoint', $partenaire?$partenaire->id:'')->attributes(['id' => 'id_conjoint']); ?>


            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="conjoint_addon" id='conjoint_addon'><?php echo $partenaire?$partenaire->IdPAD:""; ?></span>
                </div>
                <?php echo html()->text('nom_conjoint', $partenaire?$partenaire->NomComplet:"")
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'nom_conjoint','class' => 'form-control']); ?>

            </div>
        </div>
        <div class="col-md-6" align="right" >
        <?php if(!$allocataire->getFamille()): ?>
            <?php if($allocataire->IdFamilleMembre): ?>
                <span class="text-info">Membre de la Famille <a href="<?php echo e(url('familles/'.$allocataire->IdFamilleMembre)); ?>" target="_blank" class="btn btn-sm bg-info"><?php echo e($allocataire->IdFamilleMembre); ?></a></span>
            <?php else: ?>
                <span class="text-danger">Aucun Dossier Famille (allocataire seul) </span>
            <?php endif; ?>
        <?php else: ?>
            <span class="text-success">Dossier Famille <a href="<?php echo e(url('familles/'.$allocataire->id_famille)); ?>" target="_blank" class="btn btn-sm bg-success"><?php echo e($allocataire->IdPADFamille); ?></a></span>
            <?php if($allocataire->isTitulaire): ?>
                <i title="Titulaire de la famille" class="btn btn-sm bg-warning fas fa-chess-king"></i>
            <?php endif; ?>
        <?php endif; ?>

    </div>
    </div>
    <!-- PARENTS -->
    <div class="form-group row">
        <div class="col-md-6">
            <?php echo html()->label( 'Parent1','nom_parent1'); ?>

            <?php echo html()->hidden('id_parent1', null)->attributes(['id' => 'id_parent1']); ?>


            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="parent1_addon" id='parent1_addon'><?php echo ($allocataire->id_parent1)?str_pad($allocataire->id_parent1, 6, "0", STR_PAD_LEFT):''; ?></span>
                </div>
                <?php echo html()->text('nom_parent1', ($allocataire->id_parent1)?$allocataire->NomCompletParent1:'')
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'nom_parent1','class' => 'form-control']); ?>

            </div>
        </div>

        <div class="col-md-6">
            <?php echo html()->label( 'Parent2','nom_parent2'); ?>

            <?php echo html()->hidden('id_parent2', null)->attributes(['id' => 'id_parent2']); ?>


            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="parent2_addon" id='parent2_addon'><?php echo ($allocataire->id_parent2)?str_pad($allocataire->id_parent2, 6, "0", STR_PAD_LEFT):''; ?></span>
                </div>
                <?php echo html()->text('nom_parent2', ($allocataire->id_parent2)?$allocataire->NomCompletParent2:'')
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'nom_parent2','class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<! ------------- ENFANTS ----------------- ->
<div class="callout callout-secondary">
    <?php if(isset($allocataire)): ?>
        <h4>Enfants</h4>
        <div class="form-group row"> 
            <div class="col-md-12" >
                <table id="_table_enfants" class="table table-condensed table-striped table-bordered" width="100%" >
                    <thead>
                        <tr>
                            <th width='1px'>Id</th>
                            <th>Nom</th>
                            <th>Prenom</th>
                            <th width='1px'>Date&nbsp;de&nbsp;naissance</th>
                            <th width='1px'>Age</th>
                            <th width='1px'>Sexe</th>
                            <th width='1px'>Certificat</th>
                            <?php if($mode=="show"): ?>
                            <th width='1px'>
                                <a href="<?php echo url('allocataire_add_enfant/'.$allocataire->id); ?>" class="box_enfant fancybox.iframe">
                                    <button class="btn btn-sm btn-success" value="Ajouter un enfant" type="button">Ajouter un enfant</button>    
                                </a>  
                            </th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $famille_enfants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enfant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <a href="<?php echo url('allocataires/'.$enfant->Id); ?>" target="_blank" style="text-decoration:none"  class="btn btn-sm bg-secondary" >
                                        <?php echo $enfant->IdPAD; ?>

                                    </a>
                                </td>
                                <td><?php echo $enfant->NomComplet; ?></td>
                                <td nowrap><?php echo $enfant->Prenom; ?></td>
                                <td align="center"><?php echo $enfant->DateNaissance; ?></td>
                                <td align="center"><?php echo $enfant->Age; ?>&nbsp;ans</td>
                                <td align="center"><?php echo $enfant->Sexe; ?></td>
                                <td align="center"><?php echo $enfant->Certificat; ?></td>
                                <?php if($mode=="show"): ?>
                                <td nowrap>
                                    <a href="<?php echo url('enfants/'.$enfant->id); ?>" target="_blank" class="btn btn-sm  btn-warning">
                                        <span class='fas fa-eye'></span>
                                    </a> 
                                </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
</div>

<! ------------- MEMBRES ----------------- ->
<div class="callout callout-secondary">
    <?php if(isset($allocataire)): ?>
        <h4>Membres du Foyer</h4>
        <div class="form-group row"> 
            <div class="col-md-12" >
                <table id="_table_membres" class="table table-condensed table-striped table-bordered" width="100%" >
                    <thead>
                        <tr>
                            <th width='1px'>Id</th>
                            <th >Nom</th>
                            <th >Prenom</th>
                            <th width='1px'>Date&nbsp;de&nbsp;naissance</th>
                            <th width='1px'>Age</th>
                            <th width='1px'>Sexe</th>
                            <th width='1px'>Rôle</th>
                            <?php if($mode=="show"): ?>
                            <th width='1px'>
                                <a href="<?php echo url('allocataire_add_membre/'.$allocataire->id); ?>" class="box_enfant fancybox.iframe">
                                    <button class="btn btn-sm btn-success" value="Ajouter un Membre" type="button">Ajouter un membre</button>    
                                </a>  
                            </th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $famille_membres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <a href="<?php echo url('allocataires/'.$membre->Id); ?>" target="_blank" style="text-decoration:none"  class="btn btn-sm bg-secondary" >
                                        <?php echo $membre->IdPAD; ?>

                                    </a>
                                </td>
                                <td><?php echo $membre->NomComplet; ?></td>
                                <td nowrap><?php echo $membre->Prenom; ?></td>
                                <td align="center"><?php echo $membre->DateNaissance; ?></td>
                                <td align="center"><?php echo $membre->Age; ?>&nbsp;ans</td>
                                <td align="center"><?php echo $membre->Sexe; ?></td>
                                <td align="center"><?php echo $membre->Role; ?></td>
                                <?php if($mode=="show"): ?>
                                <td nowrap>
                                    <a href="<?php echo url('allocataires/'.$membre->id); ?>" target="_blank" class="btn btn-sm  btn-warning">
                                        <span class='fas fa-eye'></span>
                                    </a> 
                                </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php /**PATH /var/www/html/sigal/resources/views/tiers/allocataires/rows_foyer.blade.php ENDPATH**/ ?>