
<?php $__env->startSection('title'); ?> Versements <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',""); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header bg-<?php echo e(App\Models\MyApp::COLOR_AIDES[$type_aide]); ?>">
            <?php echo "Versement des ".App\Models\MyApp::TYPES_AIDES[$type_aide]; ?>

        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-2 mb-2">
                <?php echo html()->label("Numéro d'imprimé&nbsp;:&nbsp;",'brd'); ?>

                <?php echo html()->select('num_imp')->options($liste_num_imp)
                    ->value($num_imp)
                    ->placeholder('Choisir un mois')
                    ->attributes(['id' => 'num_imp','class' => 'form-control ']); ?>

                </div>
            </div>
            <?php if($type_aide!=""): ?>
                <div class="row">
                    <div class="table-responsive">
                        <table id="_table" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th >Allocataire</th>
                                    <th >Ile</th>
                                    <th >District</th>
                                    <th >Village</th>
                                    <?php if($type_aide=="AAE"): ?>
                                        <th>NbEnf<br/>Soc/Tot</th>
                                    <?php endif; ?>
                                    <th width='1%'>Naissance</th>
                                    <th width='10%'>Banque/ModePmt</th>
                                    <th width='10%'>Titulaire</th>
                                    <th width='10%'>Compte</th>
                                    <th width='1%'>Rappel</th>
                                    <th width='1%'>Montant</th>
                                    <th width='1%'>Total</th>
                                    <th>Observations</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nb_versements_nd=0; ?>
                                <?php $__currentLoopData = $versements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $versement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $nb_versements_nd+=(!$versement->mode_versement)?1:0;
                                    ?>
                                    <tr>
                                        <td >
                                            <a class="btn bg-info" href="<?php echo url('allocataires/'.$versement->id_allocataire); ?>" >
                                                <?php echo $versement->AllocataireIdPAD; ?>

                                            </a>
                                        </td>
                                        <td><b><?php echo $versement->destinataire_nom." ".$versement->destinataire_prenom; ?></b></td>
                                        <td><?php echo $versement->ile; ?></td>
                                        <td><?php echo $versement->district; ?></td>
                                        <td><?php echo $versement->village; ?></td>
                                        <?php if($type_aide=="AAE"): ?>
                                            <td>
                                                <?php echo $versement->AllocataireNbEnfantsAAE; ?>

                                            </td>
                                        <?php endif; ?>
                                        <td><?php echo $versement->AllocataireDateNaissance; ?></td>
                                        <td>
                                            <?php if($versement->mode_versement=="NUM"): ?>
                                                <span class="badge badge-warning right">NUMERAIRE<?php echo ($versement->procuration_nom)?" Avec procuration":""; ?></span>
                                                <?php if($versement->procuration_nom): ?>
                                                <span title="<?php echo $versement->procuration_motif; ?>"><?php echo $versement->procuration_nom."&nbsp;".$versement->procuration_prenom; ?></span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($versement->mode_versement=="VIR"): ?>
                                                <?php echo $versement->BanqueNom; ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <b><?php echo $versement->titulaire; ?></b>
                                        </td>
                                        <td nowrap>
                                            <?php if($versement->mode_versement=="VIR"): ?>
                                                <?php echo $versement->compte; ?>

                                            <?php endif; ?>
                                        </td>
                                        <td align="right" class="text-info"  nowrap>
                                            <b><?php echo $versement->montant_r; ?></b>
                                        </td>
                                        <td align="right" class="text-primary" nowrap>
                                            <b><?php echo $versement->montant; ?></b>
                                        </td>
                                        <td align="right" class="text-success" ><b><?php echo $versement->montant_r+$versement->montant; ?></b></td>
                                        <td><?php echo $versement->observations; ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php if($type_aide!=""): ?>
            <div class="card-footer">
                 <div class="row">
                    <div class="col-md-12" >
                        <a href="<?php echo url('versements_export_'.strtolower($type_aide).'/'.$num_imp); ?>" class="btn btn-warning"  target="_blank">Générer le fichier DFiP</a>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 mt-3" >
                        <!-- <a href="<?php echo url('versements_print_'.strtolower($type_aide).'/'.$num_imp); ?>" class="btn btn-primary"  target="_blank">Imprimer&nbsp;le&nbsp;borderau</a> -->
                        <a href="<?php echo url('versements_print_liste_'.strtolower($type_aide).'/'.$num_imp); ?>" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Liste complète</a>
                        <a href="<?php echo url('versements_print_dfip_'.strtolower($type_aide).'/'.$num_imp); ?>" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Virements DFiP</a>
                        <a href="<?php echo url('versements_print_vrmt_'.strtolower($type_aide).'/'.$num_imp); ?>" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Virements Autres</a>
                        <a href="<?php echo url('versements_print_num_'.strtolower($type_aide).'/'.$num_imp); ?>" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Liste Numéraires</a>
                        <a href="<?php echo url('versements_print_emargement_'.strtolower($type_aide).'/'.$num_imp); ?>" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Emargement</a>

                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
<script>
    $(function () {
        $("#num_imp").change(function() {
            reload();
        }) 
        function reload(){
            var num_imp=$('#num_imp').val();
            if(num_imp=="") aide=0;
            var url="<?php echo url('versements_aae'); ?>"+"/"+num_imp;
            location.href=url;   
        } 
    })
    </script>
    <?php echo $__env->make('forms.scripts_datatable_btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal/resources/views/versements/index.blade.php ENDPATH**/ ?>